select dti.month, dt.truck, tr_avg_speed(ft.travel)
from  fact_travel ft, dim_time dti, dim_truck dt, dim_region dr
where ft.begintime_fk = dti.timeid and dti.year = 2010 and
        dti.month >= 01 and dti.month <= 06 and 
   ft.truck_fk = dt.moid and dt.branch = '5' and
   ft.region_fk = dr.rid and r.state = 'SAO_PAULO' and
   dt.truck in (
     select  dt2.truck
     from fact_event fe, dim_time dti2, dim_event_category dty, dim_truck dt2,
	  dim_region dr2
     where fe.truck_fk = dt2.moid and dt2.branch = '5' and
      fe.begintime_fk = dti2.timeid and dti2.year = 2010 and
        dti2.month >= 01 and dti2.month <= 06 and
      fe.region_fk = dr.rid and r.state = 'SAO_PAULO' and
      fe.eventcategory_fk=dty.categoryid and dty.category='ExcessoDeVelocidade'
     having count(fe) > 100
     group by dt2.truck )
group by rollup(dti.month, dt.truck);