t=read.table("temporal.dat", header=T)

png("temp_weight_example.png")
par(cex=1.3)
plot(t$time, t$alpha0, axes=F, xlab=list("Time Point", cex=1.3), ylab=list("Weight", cex=1.3), type="o", pch=1, lty=1, cex=1.3)
points(t$time, t$alpha005, pch=2, lty=2, type="o", cex=1.3)
points(t$time, t$alpha025, pch=3, lty=3, type="o", cex=1.3)
legend(x="topleft", legend=c("0", "0.05", "0.25"), pch=c(1, 2, 3), lty=c(1, 2, 3), title="Alpha", cex=1.3)
axis(1, at=seq(min(t$time), max(t$time)))
axis(2, seq(min(t$alpha0, t$alpha005, t$alpha025) ,max(t$alpha0, t$alpha005, t$alpha025)))
dev.off()
