set terminal epslatex size 15cm,4cm color colortext
set output 'gnuplottex/jidm2015_fabio_abstract-gnuplottex-fig6.tex'
load 'defaultgnuplot.cfg'
set key top center
set key width -4
set tmargin 0.1
set lmargin 3.5
set bmargin 2.3
set grid
set style fill solid 0.5 border -1
set style data histogram
set style histogram errorbar gap 1 title textcolor lt -1
set boxwidth 0.7 relative
set xtics rotate scale 0,0
set ylabel "Mbytes" offset 2.2,0

set multiplot layout 1,2

set rmargin at screen 0.80
plot 'fig/comparacomunica2.txt' using ($2/1024):($4/1024):($3/1024):xtic(1) ti 'Estimated', '' u ($5/1024):($6/1024):($7/1024):xtic(1) dt 1 ti 'Real'

unset key
unset ytics
set y2tics
set rmargin 4
set lmargin at screen 0.81
set ylabel "Mbytes" offset 13.4,0
set border 9 back ls 11

plot 'fig/comparacomunica.txt' using ($2/1024):($4/1024):($3/1024):xtic(1) ti '', '' u ($5/1024):($6/1024):($7/1024):xtic(1) dt 1

