/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.creation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.TemplateCreationException;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationConfigurator;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationQueryer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeCreationConfigurator.class)
public class DefaultArchetypeCreationConfigurator
extends AbstractLogEnabled
implements ArchetypeCreationConfigurator {
    @Requirement
    private ArchetypeCreationQueryer archetypeCreationQueryer;
    @Requirement
    private ArchetypeFactory archetypeFactory;
    @Requirement
    private ArchetypeFilesResolver archetypeFilesResolver;

    @Override
    public Properties configureArchetypeCreation(MavenProject project, Boolean interactiveMode, Properties commandLineProperties, File propertyFile, List<String> languages) throws IOException, ArchetypeNotDefined, ArchetypeNotConfigured, PrompterException, TemplateCreationException {
        Properties properties = this.initialiseArchetypeProperties(commandLineProperties, propertyFile);
        ArchetypeDefinition archetypeDefinition = this.archetypeFactory.createArchetypeDefinition(properties);
        if (!archetypeDefinition.isDefined()) {
            archetypeDefinition = this.defineDefaultArchetype(project, properties);
        }
        ArchetypeConfiguration archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration(project, archetypeDefinition, properties);
        String resolvedPackage = this.archetypeFilesResolver.resolvePackage(project.getBasedir(), languages);
        if (!archetypeConfiguration.isConfigured()) {
            archetypeConfiguration = this.defineDefaultConfiguration(project, archetypeDefinition, resolvedPackage, properties);
        }
        if (interactiveMode.booleanValue()) {
            this.getLogger().debug("Entering interactive mode");
            boolean confirmed = false;
            while (!confirmed) {
                if (!archetypeDefinition.isDefined()) {
                    this.getLogger().debug("Archetype is yet not defined");
                    if (!archetypeDefinition.isGroupDefined()) {
                        this.getLogger().debug("Asking for archetype's groupId");
                        archetypeDefinition.setGroupId(this.archetypeCreationQueryer.getArchetypeGroupId(project.getGroupId()));
                    }
                    if (!archetypeDefinition.isArtifactDefined()) {
                        this.getLogger().debug("Asking for archetype's artifactId");
                        archetypeDefinition.setArtifactId(this.archetypeCreationQueryer.getArchetypeArtifactId(project.getArtifactId() + "-archetype"));
                    }
                    if (!archetypeDefinition.isVersionDefined()) {
                        this.getLogger().debug("Asking for archetype's version");
                        archetypeDefinition.setVersion(this.archetypeCreationQueryer.getArchetypeVersion(project.getVersion()));
                    }
                    this.archetypeFactory.updateArchetypeConfiguration(archetypeConfiguration, archetypeDefinition);
                }
                if (!archetypeConfiguration.isConfigured()) {
                    this.getLogger().debug("Archetype is not yet configured");
                    if (!archetypeConfiguration.isConfigured("groupId")) {
                        this.getLogger().debug("Asking for project's groupId");
                        archetypeConfiguration.setProperty("groupId", this.archetypeCreationQueryer.getGroupId(archetypeConfiguration.getDefaultValue("groupId")));
                    }
                    if (!archetypeConfiguration.isConfigured("artifactId")) {
                        this.getLogger().debug("Asking for project's artifactId");
                        archetypeConfiguration.setProperty("artifactId", this.archetypeCreationQueryer.getArtifactId(archetypeConfiguration.getDefaultValue("artifactId")));
                    }
                    if (!archetypeConfiguration.isConfigured("version")) {
                        this.getLogger().debug("Asking for project's version");
                        archetypeConfiguration.setProperty("version", this.archetypeCreationQueryer.getVersion(archetypeConfiguration.getDefaultValue("version")));
                    }
                    if (!archetypeConfiguration.isConfigured("package")) {
                        this.getLogger().debug("Asking for project's package");
                        archetypeConfiguration.setProperty("package", this.archetypeCreationQueryer.getPackage(StringUtils.isEmpty((String)resolvedPackage) ? archetypeConfiguration.getDefaultValue("package") : resolvedPackage));
                    }
                }
                boolean stopAddingProperties = false;
                while (!stopAddingProperties) {
                    this.getLogger().debug("Asking for another required property");
                    stopAddingProperties = !this.archetypeCreationQueryer.askAddAnotherProperty();
                    if (stopAddingProperties) continue;
                    this.getLogger().debug("Asking for required property key");
                    String propertyKey = this.archetypeCreationQueryer.askNewPropertyKey();
                    this.getLogger().debug("Asking for required property value");
                    String replacementValue = this.archetypeCreationQueryer.askReplacementValue(propertyKey, archetypeConfiguration.getDefaultValue(propertyKey));
                    archetypeConfiguration.setDefaultProperty(propertyKey, replacementValue);
                    archetypeConfiguration.setProperty(propertyKey, replacementValue);
                }
                this.getLogger().debug("Asking for configuration confirmation");
                if (this.archetypeCreationQueryer.confirmConfiguration(archetypeConfiguration)) {
                    confirmed = true;
                    continue;
                }
                this.getLogger().debug("Reseting archetype's definition and configuration");
                archetypeConfiguration.reset();
                archetypeDefinition.reset();
            }
        } else {
            this.getLogger().debug("Entering batch mode");
            if (!archetypeDefinition.isDefined()) {
                throw new ArchetypeNotDefined("The archetype is not defined");
            }
            if (!archetypeConfiguration.isConfigured()) {
                throw new ArchetypeNotConfigured("The archetype is not configured", null);
            }
        }
        return archetypeConfiguration.toProperties();
    }

    private ArchetypeDefinition defineDefaultArchetype(MavenProject project, Properties properties) {
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.groupId"))) {
            properties.setProperty("archetype.groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.artifactId"))) {
            properties.setProperty("archetype.artifactId", project.getArtifactId() + "-archetype");
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.version"))) {
            properties.setProperty("archetype.version", project.getVersion());
        }
        return this.archetypeFactory.createArchetypeDefinition(properties);
    }

    private ArchetypeConfiguration defineDefaultConfiguration(MavenProject project, ArchetypeDefinition archetypeDefinition, String resolvedPackage, Properties properties) {
        if (StringUtils.isEmpty((String)properties.getProperty("groupId"))) {
            this.getLogger().info("Setting default groupId: " + project.getGroupId());
            properties.setProperty("groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("artifactId"))) {
            this.getLogger().info("Setting default artifactId: " + project.getArtifactId());
            properties.setProperty("artifactId", project.getArtifactId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("version"))) {
            this.getLogger().info("Setting default version: " + project.getVersion());
            properties.setProperty("version", project.getVersion());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.groupId"))) {
            this.getLogger().info("Setting default archetype's groupId: " + project.getGroupId());
            properties.setProperty("archetype.groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.artifactId"))) {
            this.getLogger().info("Setting default archetype's artifactId: " + project.getArtifactId());
            properties.setProperty("archetype.artifactId", project.getArtifactId() + "-archetype");
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.version"))) {
            this.getLogger().info("Setting default archetype's version: " + project.getVersion());
            properties.setProperty("archetype.version", project.getVersion());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("package"))) {
            if (StringUtils.isEmpty((String)resolvedPackage)) {
                resolvedPackage = project.getGroupId();
            }
            this.getLogger().info("Setting default package: " + resolvedPackage);
            properties.setProperty("package", resolvedPackage);
        }
        return this.archetypeFactory.createArchetypeConfiguration(project, archetypeDefinition, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProperties(Properties properties, File propertyFile) throws IOException {
        this.getLogger().debug("Reading property file " + propertyFile);
        FileInputStream is = new FileInputStream(propertyFile);
        try {
            properties.load(is);
            this.getLogger().debug("Read " + properties.size() + " properties");
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(Properties properties, File propertyFile) throws IOException {
        Properties storedProperties = new Properties();
        try {
            this.readProperties(storedProperties, propertyFile);
        }
        catch (FileNotFoundException ex) {
            this.getLogger().debug("Property file not found. Creating a new one");
        }
        this.getLogger().debug("Adding " + properties.size() + " properties");
        for (String string : properties.keySet()) {
            storedProperties.setProperty(string, properties.getProperty(string));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(propertyFile);
        try {
            storedProperties.store(fileOutputStream, "");
            this.getLogger().debug("Stored " + storedProperties.size() + " properties");
        }
        finally {
            IOUtil.close((OutputStream)fileOutputStream);
        }
    }

    private Properties initialiseArchetypeProperties(Properties commandLineProperties, File propertyFile) throws IOException {
        Properties properties = new Properties();
        if (propertyFile != null) {
            try {
                this.readProperties(properties, propertyFile);
            }
            catch (FileNotFoundException ex) {
                this.getLogger().debug("archetype.properties does not exist");
            }
        }
        return properties;
    }

    private Properties removeDottedProperties(Properties properties) {
        ArrayList<String> toRemove = new ArrayList<String>(0);
        for (String string : properties.keySet()) {
            if (string.indexOf(".") < 0) continue;
            toRemove.add(string);
        }
        for (String string : toRemove) {
            properties.remove(string);
        }
        return properties;
    }
}

