/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationQueryer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArchetypeGenerationQueryer.class)
public class DefaultArchetypeGenerationQueryer
extends AbstractLogEnabled
implements ArchetypeGenerationQueryer {
    @Requirement
    private Prompter prompter;

    public boolean confirmConfiguration(ArchetypeConfiguration archetypeConfiguration) throws PrompterException {
        StringBuilder query = new StringBuilder("Confirm properties configuration:\n");
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            query.append(property + ": " + archetypeConfiguration.getProperty(property) + "\n");
        }
        String answer = this.prompter.prompt(query.toString(), "Y");
        return "Y".equalsIgnoreCase(answer);
    }

    public String getPropertyValue(String requiredProperty, String defaultValue) throws PrompterException {
        String query = "Define value for property '" + requiredProperty + "': ";
        String answer = defaultValue != null && !defaultValue.equals("null") ? this.prompter.prompt(query, defaultValue) : this.prompter.prompt(query);
        return answer;
    }
}

