/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;

public class StoreParamsBuilder {
    private FileMode fileMode = SystemTDB.fileMode();
    private int blockReadCacheSize = SystemTDB.BlockReadCacheSize;
    private int blockWriteCacheSize = SystemTDB.BlockWriteCacheSize;
    private int Node2NodeIdCacheSize = SystemTDB.Node2NodeIdCacheSize;
    private int NodeId2NodeCacheSize = SystemTDB.NodeId2NodeCacheSize;
    private int NodeMissCacheSize = 100;
    private int blockSize = 8192;
    private String indexNode2Id = "node2id";
    private String indexId2Node = "nodes";
    private String primaryIndexTriples = "SPO";
    private String[] tripleIndexes = Names.tripleIndexes;
    private String primaryIndexQuads = "GSPO";
    private String[] quadIndexes = Names.quadIndexes;
    private String primaryIndexPrefix = "GPU";
    private String[] prefixIndexes = Names.prefixIndexes;
    private String indexPrefix = "prefixIdx";
    private String prefixNode2Id = "prefix2id";
    private String prefixId2Node = "prefixes";

    public static StoreParamsBuilder create() {
        return new StoreParamsBuilder();
    }

    public StoreParamsBuilder() {
    }

    public StoreParamsBuilder(StoreParams other) {
        this.fileMode = other.getFileMode();
        this.blockSize = other.getBlockSize();
        this.blockReadCacheSize = other.getBlockReadCacheSize();
        this.blockWriteCacheSize = other.getBlockWriteCacheSize();
        this.Node2NodeIdCacheSize = other.getNode2NodeIdCacheSize();
        this.NodeId2NodeCacheSize = other.getNodeId2NodeCacheSize();
        this.NodeMissCacheSize = other.getNodeMissCacheSize();
        this.indexNode2Id = other.getIndexNode2Id();
        this.indexId2Node = other.getIndexId2Node();
        this.primaryIndexTriples = other.getPrimaryIndexPrefix();
        this.tripleIndexes = other.getQuadIndexes();
        this.primaryIndexQuads = other.getPrimaryIndexPrefix();
        this.quadIndexes = other.getPrefixIndexes();
        this.primaryIndexPrefix = other.getIndexPrefix();
        this.prefixIndexes = other.getPrefixIndexes();
        this.indexPrefix = other.getIndexPrefix();
        this.prefixNode2Id = other.getIndexNode2Id();
        this.prefixId2Node = other.getIndexId2Node();
    }

    public StoreParams build() {
        return new StoreParams(this.fileMode, this.blockSize, this.blockReadCacheSize, this.blockWriteCacheSize, this.Node2NodeIdCacheSize, this.NodeId2NodeCacheSize, this.NodeMissCacheSize, this.indexNode2Id, this.indexId2Node, this.primaryIndexTriples, this.tripleIndexes, this.primaryIndexQuads, this.quadIndexes, this.primaryIndexPrefix, this.prefixIndexes, this.indexPrefix, this.prefixNode2Id, this.prefixId2Node);
    }

    public FileMode getFileMode() {
        return this.fileMode;
    }

    public StoreParamsBuilder fileMode(FileMode fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public StoreParamsBuilder blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public int getBlockReadCacheSize() {
        return this.blockReadCacheSize;
    }

    public StoreParamsBuilder blockReadCacheSize(int blockReadCacheSize) {
        this.blockReadCacheSize = blockReadCacheSize;
        return this;
    }

    public int getBlockWriteCacheSize() {
        return this.blockWriteCacheSize;
    }

    public StoreParamsBuilder blockWriteCacheSize(int blockWriteCacheSize) {
        this.blockWriteCacheSize = blockWriteCacheSize;
        return this;
    }

    public int getNode2NodeIdCacheSize() {
        return this.Node2NodeIdCacheSize;
    }

    public StoreParamsBuilder node2NodeIdCacheSize(int node2NodeIdCacheSize) {
        this.Node2NodeIdCacheSize = node2NodeIdCacheSize;
        return this;
    }

    public int getNodeId2NodeCacheSize() {
        return this.NodeId2NodeCacheSize;
    }

    public StoreParamsBuilder nodeId2NodeCacheSize(int nodeId2NodeCacheSize) {
        this.NodeId2NodeCacheSize = nodeId2NodeCacheSize;
        return this;
    }

    public int getNodeMissCacheSize() {
        return this.NodeMissCacheSize;
    }

    public StoreParamsBuilder nodeMissCacheSize(int nodeMissCacheSize) {
        this.NodeMissCacheSize = nodeMissCacheSize;
        return this;
    }

    public String getIndexNode2Id() {
        return this.indexNode2Id;
    }

    public StoreParamsBuilder indexNode2Id(String indexNode2Id) {
        this.indexNode2Id = indexNode2Id;
        return this;
    }

    public String getIndexId2Node() {
        return this.indexId2Node;
    }

    public StoreParamsBuilder indexId2Node(String indexId2Node) {
        this.indexId2Node = indexId2Node;
        return this;
    }

    public String getPrimaryIndexTriples() {
        return this.primaryIndexTriples;
    }

    public StoreParamsBuilder primaryIndexTriples(String primaryIndexTriples) {
        this.primaryIndexTriples = primaryIndexTriples;
        return this;
    }

    public String[] getTripleIndexes() {
        return this.tripleIndexes;
    }

    public StoreParamsBuilder tripleIndexes(String[] tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
        return this;
    }

    public StoreParamsBuilder tripleIndexes(int idx, String tripleIndex) {
        this.tripleIndexes[idx] = tripleIndex;
        return this;
    }

    public String getPrimaryIndexQuads() {
        return this.primaryIndexQuads;
    }

    public StoreParamsBuilder primaryIndexQuads(String primaryIndexQuads) {
        this.primaryIndexQuads = primaryIndexQuads;
        return this;
    }

    public String[] getQuadIndexes() {
        return this.quadIndexes;
    }

    public StoreParamsBuilder quadIndexes(int idx, String quadIndex) {
        this.quadIndexes[idx] = quadIndex;
        return this;
    }

    public StoreParamsBuilder quadIndexes(String[] quadIndexes) {
        this.quadIndexes = quadIndexes;
        return this;
    }

    public String getPrimaryIndexPrefix() {
        return this.primaryIndexPrefix;
    }

    public StoreParamsBuilder primaryIndexPrefix(String primaryIndexPrefix) {
        this.primaryIndexPrefix = primaryIndexPrefix;
        return this;
    }

    public String[] getPrefixIndexes() {
        return this.prefixIndexes;
    }

    public StoreParamsBuilder prefixIndexes(String[] prefixIndexes) {
        this.prefixIndexes = prefixIndexes;
        return this;
    }

    public StoreParamsBuilder prefixIndexes(int idx, String prefixIndex) {
        this.prefixIndexes[idx] = prefixIndex;
        return this;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public StoreParamsBuilder indexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
        return this;
    }

    public String getPrefixNode2Id() {
        return this.prefixNode2Id;
    }

    public StoreParamsBuilder prefixNode2Id(String prefixNode2Id) {
        this.prefixNode2Id = prefixNode2Id;
        return this;
    }

    public String getPrefixId2Node() {
        return this.prefixId2Node;
    }

    public StoreParamsBuilder prefixId2Node(String prefixId2Node) {
        this.prefixId2Node = prefixId2Node;
        return this;
    }
}

