/*
 * Decompiled with CFR 0.152.
 */
package org.grails.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.grails.wrapper.RemoteFileHelper;

public class GrailsWrapper {
    public static void main(String[] args) throws Exception {
        URL groovyJarUrl;
        ResourceBundle applicationBundle = ResourceBundle.getBundle("application");
        ResourceBundle wrapperBundle = ResourceBundle.getBundle("grails-wrapper");
        String grailsVersion = applicationBundle.getString("app.grails.version");
        String distUrl = wrapperBundle.getString("wrapper.dist.url");
        if (distUrl == null) {
            distUrl = "http://dist.springframework.org.s3.amazonaws.com/release/GRAILS/";
        }
        if (!distUrl.endsWith("/")) {
            distUrl = distUrl + "/";
        }
        GrailsWrapper.addSystemProperties(wrapperBundle);
        File grailsHome = GrailsWrapper.configureGrailsInstallation(distUrl, grailsVersion);
        System.setProperty("grails.home", grailsHome.getAbsolutePath());
        ArrayList<String> newArgsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--main".equals(arg) && i < args.length - 1) {
                ++i;
                continue;
            }
            if ("--conf".equals(arg) && i < args.length - 1) {
                newArgsList.add(arg);
                File groovyStarterConf = new File(grailsHome, "conf/groovy-starter.conf");
                newArgsList.add(groovyStarterConf.getAbsolutePath());
                ++i;
                continue;
            }
            newArgsList.add(arg);
        }
        String[] newArgsArray = newArgsList.toArray(new String[0]);
        URL[] urls = new URL[2];
        urls[0] = new File(grailsHome, "dist/grails-bootstrap-" + grailsVersion + ".jar").toURI().toURL();
        File directoryToSearchForGroovyAllJar = new File(grailsHome, "/lib/org.codehaus.groovy");
        File groovyJar = GrailsWrapper.findGroovyAllJar(directoryToSearchForGroovyAllJar);
        if (groovyJar == null) {
            System.err.println("An error occurred locating the groovy jar under " + directoryToSearchForGroovyAllJar.getAbsolutePath());
            System.exit(-1);
        }
        URI groovyJarUri = groovyJar.toURI();
        urls[1] = groovyJarUrl = groovyJarUri.toURL();
        URLClassLoader urlClassLoader = new URLClassLoader(urls);
        Class<?> loadClass = urlClassLoader.loadClass("org.codehaus.groovy.grails.cli.support.GrailsStarter");
        Method mainMethod = loadClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{newArgsArray});
    }

    private static void addSystemProperties(ResourceBundle wrapperBundle) {
        String prefix = "systemProp.";
        for (String key : wrapperBundle.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String systemKey = key.substring(prefix.length());
            System.getProperties().put(systemKey, wrapperBundle.getString(key));
        }
    }

    private static File findGroovyAllJar(File directoryToSearch) {
        File[] files;
        for (File file : files = directoryToSearch.listFiles()) {
            if (file.isDirectory()) {
                return GrailsWrapper.findGroovyAllJar(file);
            }
            String fileName = file.getName();
            if (!fileName.matches("groovy-all-(\\d+)(\\.\\d+)*\\.jar")) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File configureGrailsInstallation(String distUrl, String grailsVersion) throws Exception {
        String src = distUrl + "grails-" + grailsVersion + ".zip";
        URI uri = new URI(src);
        File grailsCacheDir = new File(System.getProperty("user.home") + "/.grails/");
        File wrapperDir = new File(grailsCacheDir, "wrapper");
        File installDir = new File(wrapperDir, grailsVersion);
        File downloadFile = null;
        if (!installDir.exists()) {
            try {
                downloadFile = new File(wrapperDir, "grails-" + grailsVersion + "-download.zip");
                new RemoteFileHelper().retrieve(uri, downloadFile);
                GrailsWrapper.extract(downloadFile, installDir);
            }
            finally {
                try {
                    if (downloadFile != null && downloadFile.exists()) {
                        downloadFile.delete();
                    }
                }
                catch (Exception e) {}
            }
        }
        File grailsHome = new File(installDir, "grails-" + grailsVersion);
        return grailsHome;
    }

    public static void extract(File zip, File dest) throws IOException {
        System.out.println("Extracting " + zip.getAbsolutePath() + " to " + dest.getAbsolutePath());
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(dest, entry.getName()).mkdirs();
                continue;
            }
            GrailsWrapper.copy(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(dest, entry.getName()))));
        }
        zipFile.close();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

