/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.ByteArrayUtil;
import info.aduna.iteration.LookAheadIteration;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;
import org.openrdf.sail.nativerdf.model.NativeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeStatementIterator
extends LookAheadIteration<Statement, IOException> {
    private final RecordIterator btreeIter;
    private final ValueStore valueStore;

    public NativeStatementIterator(RecordIterator btreeIter, ValueStore valueStore) throws IOException {
        this.btreeIter = btreeIter;
        this.valueStore = valueStore;
    }

    public Statement getNextElement() throws IOException {
        byte[] nextValue = this.btreeIter.next();
        if (nextValue == null) {
            return null;
        }
        int subjID = ByteArrayUtil.getInt((byte[])nextValue, (int)0);
        Resource subj = (Resource)this.valueStore.getValue(subjID);
        int predID = ByteArrayUtil.getInt((byte[])nextValue, (int)4);
        URI pred = (URI)this.valueStore.getValue(predID);
        int objID = ByteArrayUtil.getInt((byte[])nextValue, (int)8);
        NativeValue obj = this.valueStore.getValue(objID);
        Resource context = null;
        int contextID = ByteArrayUtil.getInt((byte[])nextValue, (int)12);
        if (contextID != 0) {
            context = (Resource)this.valueStore.getValue(contextID);
        }
        return this.valueStore.createStatement(subj, pred, obj, context);
    }

    protected void handleClose() throws IOException {
        super.handleClose();
        this.btreeIter.close();
    }
}

