/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.ConstructorBuilder;
import org.openrdf.query.parser.serql.GraphPattern;
import org.openrdf.query.parser.serql.ast.ASTAnd;
import org.openrdf.query.parser.serql.ast.ASTBNode;
import org.openrdf.query.parser.serql.ast.ASTBasicPathExpr;
import org.openrdf.query.parser.serql.ast.ASTBasicPathExprTail;
import org.openrdf.query.parser.serql.ast.ASTBooleanConstant;
import org.openrdf.query.parser.serql.ast.ASTBooleanExpr;
import org.openrdf.query.parser.serql.ast.ASTBound;
import org.openrdf.query.parser.serql.ast.ASTCompare;
import org.openrdf.query.parser.serql.ast.ASTCompareAll;
import org.openrdf.query.parser.serql.ast.ASTCompareAny;
import org.openrdf.query.parser.serql.ast.ASTConstruct;
import org.openrdf.query.parser.serql.ast.ASTConstructQuery;
import org.openrdf.query.parser.serql.ast.ASTDatatype;
import org.openrdf.query.parser.serql.ast.ASTEdge;
import org.openrdf.query.parser.serql.ast.ASTExists;
import org.openrdf.query.parser.serql.ast.ASTFrom;
import org.openrdf.query.parser.serql.ast.ASTFunctionCall;
import org.openrdf.query.parser.serql.ast.ASTGraphIntersect;
import org.openrdf.query.parser.serql.ast.ASTGraphMinus;
import org.openrdf.query.parser.serql.ast.ASTGraphUnion;
import org.openrdf.query.parser.serql.ast.ASTIn;
import org.openrdf.query.parser.serql.ast.ASTInList;
import org.openrdf.query.parser.serql.ast.ASTIsBNode;
import org.openrdf.query.parser.serql.ast.ASTIsLiteral;
import org.openrdf.query.parser.serql.ast.ASTIsResource;
import org.openrdf.query.parser.serql.ast.ASTIsURI;
import org.openrdf.query.parser.serql.ast.ASTLabel;
import org.openrdf.query.parser.serql.ast.ASTLang;
import org.openrdf.query.parser.serql.ast.ASTLangMatches;
import org.openrdf.query.parser.serql.ast.ASTLike;
import org.openrdf.query.parser.serql.ast.ASTLimit;
import org.openrdf.query.parser.serql.ast.ASTLiteral;
import org.openrdf.query.parser.serql.ast.ASTLocalName;
import org.openrdf.query.parser.serql.ast.ASTNamespace;
import org.openrdf.query.parser.serql.ast.ASTNode;
import org.openrdf.query.parser.serql.ast.ASTNodeElem;
import org.openrdf.query.parser.serql.ast.ASTNot;
import org.openrdf.query.parser.serql.ast.ASTNull;
import org.openrdf.query.parser.serql.ast.ASTOffset;
import org.openrdf.query.parser.serql.ast.ASTOptPathExpr;
import org.openrdf.query.parser.serql.ast.ASTOptPathExprTail;
import org.openrdf.query.parser.serql.ast.ASTOr;
import org.openrdf.query.parser.serql.ast.ASTOrderBy;
import org.openrdf.query.parser.serql.ast.ASTOrderExpr;
import org.openrdf.query.parser.serql.ast.ASTPathExpr;
import org.openrdf.query.parser.serql.ast.ASTPathExprTail;
import org.openrdf.query.parser.serql.ast.ASTPathExprUnion;
import org.openrdf.query.parser.serql.ast.ASTProjectionElem;
import org.openrdf.query.parser.serql.ast.ASTQueryBody;
import org.openrdf.query.parser.serql.ast.ASTQueryContainer;
import org.openrdf.query.parser.serql.ast.ASTRegex;
import org.openrdf.query.parser.serql.ast.ASTReifiedStat;
import org.openrdf.query.parser.serql.ast.ASTSameTerm;
import org.openrdf.query.parser.serql.ast.ASTSelect;
import org.openrdf.query.parser.serql.ast.ASTSelectQuery;
import org.openrdf.query.parser.serql.ast.ASTStr;
import org.openrdf.query.parser.serql.ast.ASTString;
import org.openrdf.query.parser.serql.ast.ASTTupleIntersect;
import org.openrdf.query.parser.serql.ast.ASTTupleMinus;
import org.openrdf.query.parser.serql.ast.ASTTupleUnion;
import org.openrdf.query.parser.serql.ast.ASTURI;
import org.openrdf.query.parser.serql.ast.ASTValueExpr;
import org.openrdf.query.parser.serql.ast.ASTVar;
import org.openrdf.query.parser.serql.ast.ASTWhere;
import org.openrdf.query.parser.serql.ast.Node;
import org.openrdf.query.parser.serql.ast.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryModelBuilder
extends ASTVisitorBase {
    private final ValueFactory valueFactory;
    private int constantVarID = 1;
    private GraphPattern graphPattern;

    public static TupleExpr buildQueryModel(ASTQueryContainer node, ValueFactory valueFactory) throws MalformedQueryException {
        try {
            QueryModelBuilder qmBuilder = new QueryModelBuilder(valueFactory);
            return (TupleExpr)node.jjtAccept(qmBuilder, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public QueryModelBuilder(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    private Var createConstantVar(Value value) {
        Var var = new Var("-const-" + this.constantVarID++);
        var.setAnonymous(true);
        var.setValue(value);
        return var;
    }

    private GraphPattern parseGraphPattern(Node node) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        try {
            node.jjtAccept(this, null);
            GraphPattern graphPattern = this.graphPattern;
            return graphPattern;
        }
        finally {
            this.graphPattern = this.graphPattern.getParent();
        }
    }

    public TupleExpr visit(ASTQueryContainer node, Object data) throws VisitorException {
        return (TupleExpr)node.getQuery().jjtAccept(this, null);
    }

    public TupleExpr visit(ASTTupleUnion node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        Union result = new Union(leftArg, rightArg);
        if (node.isDistinct()) {
            result = new Distinct((TupleExpr)result);
        }
        return result;
    }

    public TupleExpr visit(ASTTupleMinus node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        return new Difference(leftArg, rightArg);
    }

    public TupleExpr visit(ASTTupleIntersect node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        return new Intersection(leftArg, rightArg);
    }

    public TupleExpr visit(ASTGraphUnion node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        Union result = new Union(leftArg, rightArg);
        if (node.isDistinct()) {
            result = new Distinct((TupleExpr)result);
        }
        return result;
    }

    public TupleExpr visit(ASTGraphMinus node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        return new Difference(leftArg, rightArg);
    }

    public TupleExpr visit(ASTGraphIntersect node, Object data) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node.getRightArg().jjtAccept(this, null);
        return new Intersection(leftArg, rightArg);
    }

    public TupleExpr visit(ASTSelectQuery node, Object data) throws VisitorException {
        ASTQueryBody queryBodyNode = node.getQueryBody();
        Object tupleExpr = queryBodyNode != null ? (TupleExpr)queryBodyNode.jjtAccept(this, null) : new SingletonSet();
        ASTOrderBy orderByNode = node.getOrderBy();
        if (orderByNode != null) {
            List orderElemements = (List)orderByNode.jjtAccept(this, null);
            tupleExpr = new Order((TupleExpr)tupleExpr, (Iterable)orderElemements);
        }
        tupleExpr = (TupleExpr)node.getSelectClause().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice((TupleExpr)tupleExpr, (long)offset, (long)limit);
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTSelect node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        Extension extension = new Extension();
        ProjectionElemList projElemList = new ProjectionElemList();
        for (ASTProjectionElem projElemNode : node.getProjectionElemList()) {
            ValueExpr valueExpr = (ValueExpr)projElemNode.getValueExpr().jjtAccept(this, null);
            String alias = projElemNode.getAlias();
            if (alias != null) {
                extension.addElement(new ExtensionElem(valueExpr, alias));
                projElemList.addElement(new ProjectionElem(alias));
                continue;
            }
            if (valueExpr instanceof Var) {
                Var projVar = (Var)valueExpr;
                projElemList.addElement(new ProjectionElem(projVar.getName()));
                continue;
            }
            throw new IllegalStateException("required alias for non-Var projection elements not found");
        }
        if (!extension.getElements().isEmpty()) {
            extension.setArg(result);
            result = extension;
        }
        result = new Projection(result, projElemList);
        if (node.isDistinct()) {
            result = new Distinct(result);
        } else if (node.isReduced()) {
            result = new Reduced(result);
        }
        return result;
    }

    public TupleExpr visit(ASTConstructQuery node, Object data) throws VisitorException {
        Object tupleExpr = node.hasQueryBody() ? (TupleExpr)node.getQueryBody().jjtAccept(this, null) : new SingletonSet();
        ASTOrderBy orderByNode = node.getOrderBy();
        if (orderByNode != null) {
            List orderElemements = (List)orderByNode.jjtAccept(this, null);
            tupleExpr = new Order((TupleExpr)tupleExpr, (Iterable)orderElemements);
        }
        ConstructorBuilder cb = new ConstructorBuilder();
        ASTConstruct constructNode = node.getConstructClause();
        if (!constructNode.isWildcard()) {
            TupleExpr constructExpr = (TupleExpr)constructNode.jjtAccept(this, null);
            tupleExpr = cb.buildConstructor((TupleExpr)tupleExpr, constructExpr, constructNode.isDistinct(), constructNode.isReduced());
        } else if (node.hasQueryBody()) {
            tupleExpr = cb.buildConstructor((TupleExpr)tupleExpr, constructNode.isDistinct(), constructNode.isReduced());
        }
        ASTLimit limitNode = node.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice((TupleExpr)tupleExpr, (long)offset, (long)limit);
        }
        return tupleExpr;
    }

    public TupleExpr visit(ASTConstruct node, Object data) throws VisitorException {
        assert (!node.isWildcard()) : "Cannot build constructor for wildcards";
        return this.parseGraphPattern(node.getPathExpr()).buildTupleExpr();
    }

    public TupleExpr visit(ASTQueryBody node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        try {
            super.visit(node, data);
            TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
            return tupleExpr;
        }
        finally {
            this.graphPattern = this.graphPattern.getParent();
        }
    }

    @Override
    public Object visit(ASTFrom node, Object data) throws VisitorException {
        StatementPattern.Scope scope = StatementPattern.Scope.DEFAULT_CONTEXTS;
        Var contextVar = null;
        if (node.hasContextID()) {
            scope = StatementPattern.Scope.NAMED_CONTEXTS;
            ValueExpr contextID = (ValueExpr)node.getContextID().jjtAccept(this, null);
            if (contextID instanceof Var) {
                contextVar = (Var)contextID;
            } else if (contextID instanceof ValueConstant) {
                ValueConstant vc = (ValueConstant)contextID;
                contextVar = this.createConstantVar(vc.getValue());
            } else {
                throw new IllegalArgumentException("Unexpected contextID result type: " + contextID.getClass());
            }
        }
        this.graphPattern.setStatementPatternScope(scope);
        this.graphPattern.setContextVar(contextVar);
        node.getPathExpr().jjtAccept(this, null);
        return null;
    }

    @Override
    public Object visit(ASTWhere node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getCondition().jjtAccept(this, null);
        this.graphPattern.addConstraint(valueExpr);
        return null;
    }

    @Override
    public List<OrderElem> visit(ASTOrderBy node, Object data) throws VisitorException {
        List<ASTOrderExpr> orderExprList = node.getOrderExprList();
        ArrayList<OrderElem> elements = new ArrayList<OrderElem>(orderExprList.size());
        for (ASTOrderExpr orderExpr : orderExprList) {
            elements.add((OrderElem)orderExpr.jjtAccept(this, null));
        }
        return elements;
    }

    public OrderElem visit(ASTOrderExpr node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getValueExpr().jjtAccept(this, null);
        return new OrderElem(valueExpr, node.isAscending());
    }

    @Override
    public Integer visit(ASTLimit node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Integer visit(ASTOffset node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Object visit(ASTPathExprUnion node, Object data) throws VisitorException {
        Iterator<ASTPathExpr> args = node.getPathExprList().iterator();
        TupleExpr unionExpr = this.parseGraphPattern(args.next()).buildTupleExpr();
        while (args.hasNext()) {
            TupleExpr argExpr = this.parseGraphPattern(args.next()).buildTupleExpr();
            unionExpr = new Union(unionExpr, argExpr);
        }
        this.graphPattern.addRequiredTE(unionExpr);
        return null;
    }

    @Override
    public Object visit(ASTBasicPathExpr node, Object data) throws VisitorException {
        List subjVars = (List)node.getHead().jjtAccept(this, null);
        node.getTail().jjtAccept(this, subjVars);
        return null;
    }

    @Override
    public Object visit(ASTOptPathExpr node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        super.visit(node, data);
        this.graphPattern.getParent().addOptionalTE(this.graphPattern);
        this.graphPattern = this.graphPattern.getParent();
        return null;
    }

    @Override
    public Object visit(ASTBasicPathExprTail tailNode, Object data) throws VisitorException {
        List subjVars = (List)data;
        Var predVar = (Var)tailNode.getEdge().jjtAccept(this, null);
        List objVars = (List)tailNode.getNode().jjtAccept(this, null);
        Var contextVar = this.graphPattern.getContextVar();
        StatementPattern.Scope spScope = this.graphPattern.getStatementPatternScope();
        for (Var subjVar : subjVars) {
            for (Var objVar : objVars) {
                StatementPattern sp = new StatementPattern(spScope, subjVar, predVar, objVar, contextVar);
                this.graphPattern.addRequiredTE((TupleExpr)sp);
            }
        }
        ASTPathExprTail nextTailNode = tailNode.getNextTail();
        if (nextTailNode != null) {
            List joinVars = nextTailNode.isBranch() ? subjVars : objVars;
            nextTailNode.jjtAccept(this, joinVars);
        }
        return null;
    }

    @Override
    public Object visit(ASTOptPathExprTail tailNode, Object data) throws VisitorException {
        List subjVars = (List)data;
        this.graphPattern = new GraphPattern(this.graphPattern);
        tailNode.getOptionalTail().jjtAccept(this, subjVars);
        ASTWhere whereNode = tailNode.getWhereClause();
        if (whereNode != null) {
            whereNode.jjtAccept(this, null);
        }
        this.graphPattern.getParent().addOptionalTE(this.graphPattern);
        this.graphPattern = this.graphPattern.getParent();
        ASTPathExprTail nextTailNode = tailNode.getNextTail();
        if (nextTailNode != null) {
            nextTailNode.jjtAccept(this, subjVars);
        }
        return null;
    }

    public Var visit(ASTEdge node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.getValueExpr().jjtAccept(this, null);
        if (arg instanceof Var) {
            return (Var)arg;
        }
        if (arg instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)arg;
            return this.createConstantVar(vc.getValue());
        }
        throw new IllegalArgumentException("Unexpected edge argument type: " + arg.getClass());
    }

    @Override
    public List<Var> visit(ASTNode node, Object data) throws VisitorException {
        ArrayList<Var> nodeVars = new ArrayList<Var>();
        for (ASTNodeElem nodeElem : node.getNodeElemList()) {
            Var nodeVar = (Var)nodeElem.jjtAccept(this, null);
            nodeVars.add(nodeVar);
        }
        int i = 0;
        while (i < nodeVars.size() - 1) {
            Var var1 = (Var)nodeVars.get(i);
            int j = i + 1;
            while (j < nodeVars.size()) {
                Var var2 = (Var)nodeVars.get(j);
                if (!var1.hasValue() || !var2.hasValue()) {
                    this.graphPattern.addConstraint((ValueExpr)new Not((ValueExpr)new SameTerm((ValueExpr)var1, (ValueExpr)var2)));
                }
                ++j;
            }
            ++i;
        }
        return nodeVars;
    }

    public Var visit(ASTNodeElem node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getChild().jjtAccept(this, null);
        if (valueExpr instanceof Var) {
            return (Var)valueExpr;
        }
        if (valueExpr instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)valueExpr;
            return this.createConstantVar(vc.getValue());
        }
        throw new IllegalArgumentException("Unexpected node element result type: " + valueExpr.getClass());
    }

    public Var visit(ASTReifiedStat node, Object data) throws VisitorException {
        assert (node.getID() != null) : "ID variable not set";
        Var subjVar = (Var)node.getSubject().jjtAccept(this, null);
        Var predVar = (Var)node.getPredicate().jjtAccept(this, null);
        Var objVar = (Var)node.getObject().jjtAccept(this, null);
        Var idVar = (Var)node.getID().jjtAccept(this, null);
        Var contextVar = this.graphPattern.getContextVar();
        StatementPattern.Scope spScope = this.graphPattern.getStatementPatternScope();
        Var rdfType = new Var("_rdfType", (Value)RDF.TYPE);
        Var rdfStatement = new Var("_rdfStatement", (Value)RDF.STATEMENT);
        Var rdfSubject = new Var("_rdfSubject", (Value)RDF.SUBJECT);
        Var rdfPredicate = new Var("_rdfPredicate", (Value)RDF.PREDICATE);
        Var rdfObject = new Var("_rdfObject", (Value)RDF.OBJECT);
        this.graphPattern.addRequiredTE((TupleExpr)new StatementPattern(spScope, idVar, rdfType, rdfStatement, contextVar));
        this.graphPattern.addRequiredTE((TupleExpr)new StatementPattern(spScope, idVar, rdfSubject, subjVar, contextVar));
        this.graphPattern.addRequiredTE((TupleExpr)new StatementPattern(spScope, idVar, rdfPredicate, predVar, contextVar));
        this.graphPattern.addRequiredTE((TupleExpr)new StatementPattern(spScope, idVar, rdfObject, objVar, contextVar));
        return idVar;
    }

    public ValueExpr visit(ASTOr node, Object data) throws VisitorException {
        Iterator<ASTBooleanExpr> iter = node.getOperandList().iterator();
        ValueExpr result = (ValueExpr)iter.next().jjtAccept(this, null);
        while (iter.hasNext()) {
            ValueExpr operand = (ValueExpr)iter.next().jjtAccept(this, null);
            result = new Or(result, operand);
        }
        return result;
    }

    public ValueExpr visit(ASTAnd node, Object data) throws VisitorException {
        Iterator<ASTBooleanExpr> iter = node.getOperandList().iterator();
        ValueExpr result = (ValueExpr)iter.next().jjtAccept(this, null);
        while (iter.hasNext()) {
            ValueExpr operand = (ValueExpr)iter.next().jjtAccept(this, null);
            result = new And(result, operand);
        }
        return result;
    }

    public ValueConstant visit(ASTBooleanConstant node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createLiteral(node.getValue()));
    }

    public Not visit(ASTNot node, Object data) throws VisitorException {
        return new Not((ValueExpr)super.visit(node, data));
    }

    public Bound visit(ASTBound node, Object data) throws VisitorException {
        return new Bound((Var)super.visit(node, data));
    }

    public IsResource visit(ASTIsResource node, Object data) throws VisitorException {
        return new IsResource((ValueExpr)super.visit(node, data));
    }

    public IsLiteral visit(ASTIsLiteral node, Object data) throws VisitorException {
        return new IsLiteral((ValueExpr)super.visit(node, data));
    }

    public IsURI visit(ASTIsURI node, Object data) throws VisitorException {
        return new IsURI((ValueExpr)super.visit(node, data));
    }

    public IsBNode visit(ASTIsBNode node, Object data) throws VisitorException {
        return new IsBNode((ValueExpr)super.visit(node, data));
    }

    public LangMatches visit(ASTLangMatches node, Object data) throws VisitorException {
        ValueExpr tag = (ValueExpr)node.getLanguageTag().jjtAccept(this, null);
        ValueExpr range = (ValueExpr)node.getLanguageRange().jjtAccept(this, null);
        return new LangMatches(tag, range);
    }

    public Exists visit(ASTExists node, Object data) throws VisitorException {
        return new Exists((TupleExpr)super.visit(node, data));
    }

    public SameTerm visit(ASTSameTerm node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.getLeftOperand().jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.getRightOperand().jjtAccept(this, null);
        return new SameTerm(leftArg, rightArg);
    }

    public Compare visit(ASTCompare node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.getLeftOperand().jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp operator = node.getOperator().getValue();
        return new Compare(leftArg, rightArg, operator);
    }

    public CompareAny visit(ASTCompareAny node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp op = node.getOperator().getValue();
        return new CompareAny(valueExpr, tupleExpr, op);
    }

    public CompareAll visit(ASTCompareAll node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp op = node.getOperator().getValue();
        return new CompareAll(valueExpr, tupleExpr, op);
    }

    public Like visit(ASTLike node, Object data) throws VisitorException {
        ValueExpr expr = (ValueExpr)node.getValueExpr().jjtAccept(this, null);
        String pattern = (String)node.getPattern().jjtAccept(this, null);
        boolean caseSensitive = !node.ignoreCase();
        return new Like(expr, pattern, caseSensitive);
    }

    public Regex visit(ASTRegex node, Object data) throws VisitorException {
        ValueExpr text = (ValueExpr)node.getText().jjtAccept(this, null);
        ValueExpr pattern = (ValueExpr)node.getPattern().jjtAccept(this, null);
        ValueExpr flags = null;
        if (node.hasFlags()) {
            flags = (ValueExpr)node.getFlags().jjtAccept(this, null);
        }
        return new Regex(text, pattern, flags);
    }

    public In visit(ASTIn node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node.getRightOperand().jjtAccept(this, null);
        return new In(valueExpr, tupleExpr);
    }

    public ValueExpr visit(ASTInList node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.getValueExpr().jjtAccept(this, null);
        SameTerm result = null;
        for (ASTValueExpr argExpr : node.getArgList().getElements()) {
            ValueExpr rightArg = (ValueExpr)argExpr.jjtAccept(this, null);
            if (result == null) {
                result = new SameTerm(leftArg, rightArg);
                continue;
            }
            SameTerm sameTerm = new SameTerm(leftArg.clone(), rightArg);
            result = new Or((ValueExpr)result, (ValueExpr)sameTerm);
        }
        assert (result != null);
        return result;
    }

    public Var visit(ASTVar node, Object data) throws VisitorException {
        Var var = new Var(node.getName());
        var.setAnonymous(node.isAnonymous());
        return var;
    }

    public Datatype visit(ASTDatatype node, Object data) throws VisitorException {
        return new Datatype((ValueExpr)super.visit(node, data));
    }

    public Lang visit(ASTLang node, Object data) throws VisitorException {
        return new Lang((ValueExpr)super.visit(node, data));
    }

    public Label visit(ASTLabel node, Object data) throws VisitorException {
        return new Label((ValueExpr)super.visit(node, data));
    }

    public Namespace visit(ASTNamespace node, Object data) throws VisitorException {
        return new Namespace((ValueExpr)super.visit(node, data));
    }

    public LocalName visit(ASTLocalName node, Object data) throws VisitorException {
        return new LocalName((ValueExpr)super.visit(node, data));
    }

    public Str visit(ASTStr node, Object data) throws VisitorException {
        return new Str((ValueExpr)super.visit(node, data));
    }

    public FunctionCall visit(ASTFunctionCall node, Object data) throws VisitorException {
        ValueConstant vc = (ValueConstant)node.getURI().jjtAccept(this, null);
        assert (vc.getValue() instanceof URI);
        FunctionCall functionCall = new FunctionCall(vc.getValue().toString(), new ValueExpr[0]);
        for (ASTValueExpr argExpr : node.getArgList().getElements()) {
            functionCall.addArg((ValueExpr)argExpr.jjtAccept(this, null));
        }
        return functionCall;
    }

    @Override
    public Object visit(ASTNull node, Object data) throws VisitorException {
        throw new VisitorException("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
    }

    public ValueConstant visit(ASTURI node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createURI(node.getValue()));
    }

    public ValueConstant visit(ASTBNode node, Object data) throws VisitorException {
        return new ValueConstant((Value)this.valueFactory.createBNode(node.getID()));
    }

    public ValueConstant visit(ASTLiteral litNode, Object data) throws VisitorException {
        URI datatype = null;
        ASTValueExpr dtNode = litNode.getDatatypeNode();
        if (dtNode instanceof ASTURI) {
            datatype = this.valueFactory.createURI(((ASTURI)dtNode).getValue());
        } else if (dtNode != null) {
            throw new IllegalArgumentException("Unexpected datatype type: " + dtNode.getClass());
        }
        Literal literal = datatype != null ? this.valueFactory.createLiteral(litNode.getLabel(), datatype) : (litNode.hasLang() ? this.valueFactory.createLiteral(litNode.getLabel(), litNode.getLang()) : this.valueFactory.createLiteral(litNode.getLabel()));
        return new ValueConstant((Value)literal);
    }

    @Override
    public String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }
}

