/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.protocol.transaction;

import info.aduna.xml.SimpleSAXAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionSAXParser
extends SimpleSAXAdapter {
    private ValueFactory valueFactory;
    private List<TransactionOperation> txn;
    private List<Value> parsedValues = new ArrayList<Value>();

    public TransactionSAXParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public TransactionSAXParser(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Collection<TransactionOperation> getTxn() {
        return this.txn;
    }

    public void startDocument() throws SAXException {
        this.txn = new ArrayList<TransactionOperation>();
    }

    public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
        if ("uri".equals(tagName)) {
            this.parsedValues.add((Value)this.valueFactory.createURI(text));
        } else if ("bnode".equals(tagName)) {
            this.parsedValues.add((Value)this.valueFactory.createBNode(text));
        } else if ("literal".equals(tagName)) {
            Literal lit;
            String lang = atts.get("xml:lang");
            String datatype = atts.get("datatype");
            if (lang != null) {
                lit = this.valueFactory.createLiteral(text, lang);
            } else if (datatype != null) {
                URI dtURI = this.valueFactory.createURI(datatype);
                lit = this.valueFactory.createLiteral(text, dtURI);
            } else {
                lit = this.valueFactory.createLiteral(text);
            }
            this.parsedValues.add((Value)lit);
        } else if ("null".equals(tagName)) {
            this.parsedValues.add(null);
        } else if ("setNamespace".equals(tagName)) {
            String prefix = atts.get("prefix");
            String name = atts.get("name");
            this.txn.add(new SetNamespaceOperation(prefix, name));
        } else if ("removeNamespace".equals(tagName)) {
            String prefix = atts.get("prefix");
            this.txn.add(new RemoveNamespaceOperation(prefix));
        } else if ("clearNamespaces".equals(tagName)) {
            this.txn.add(new ClearNamespacesOperation());
        }
    }

    public void endTag(String tagName) throws SAXException {
        if ("add".equals(tagName)) {
            this.txn.add(this.createAddStatementOperation());
        } else if ("remove".equals(tagName)) {
            this.txn.add(this.createRemoveStatementsOperation());
        } else if ("clear".equals(tagName)) {
            this.txn.add(this.createClearOperation());
        }
    }

    private TransactionOperation createClearOperation() throws SAXException {
        Resource[] contexts = this.createContexts(0);
        this.parsedValues.clear();
        return new ClearOperation(contexts);
    }

    private TransactionOperation createAddStatementOperation() throws SAXException {
        if (this.parsedValues.size() < 3) {
            throw new SAXException("At least three values required for AddStatementOperation, found: " + this.parsedValues.size());
        }
        try {
            Resource subject = (Resource)this.parsedValues.get(0);
            URI predicate = (URI)this.parsedValues.get(1);
            Value object = this.parsedValues.get(2);
            Resource[] contexts = this.createContexts(3);
            this.parsedValues.clear();
            if (subject == null || predicate == null || object == null) {
                throw new SAXException("Subject, predicate and object cannot be null for an AddStatementOperation");
            }
            return new AddStatementOperation(subject, predicate, object, contexts);
        }
        catch (ClassCastException e) {
            throw new SAXException("Invalid argument(s) for AddStatementOperation", e);
        }
    }

    private TransactionOperation createRemoveStatementsOperation() throws SAXException {
        if (this.parsedValues.size() < 3) {
            throw new SAXException("At least three values required for RemoveStatementsOperation, found: " + this.parsedValues.size());
        }
        try {
            Resource subject = (Resource)this.parsedValues.get(0);
            URI predicate = (URI)this.parsedValues.get(1);
            Value object = this.parsedValues.get(2);
            Resource[] contexts = this.createContexts(3);
            this.parsedValues.clear();
            return new RemoveStatementsOperation(subject, predicate, object, contexts);
        }
        catch (ClassCastException e) {
            throw new SAXException("Invalid argument(s) for RemoveStatementsOperation", e);
        }
    }

    private Resource[] createContexts(int startIdx) throws SAXException {
        ArrayList<Resource> contexts = new ArrayList<Resource>();
        for (int i = startIdx; i < this.parsedValues.size(); ++i) {
            Value contextCandidate = this.parsedValues.get(i);
            if (contextCandidate != null && !(contextCandidate instanceof Resource)) {
                throw new SAXException("Invalid context value: " + contextCandidate.getClass());
            }
            contexts.add((Resource)contextCandidate);
        }
        return contexts.toArray(new Resource[contexts.size()]);
    }
}

