/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.AbstractMember;

public class FieldMember
extends AbstractMember {
    static final FieldMember[] NONE = new FieldMember[0];
    String typename;

    protected FieldMember(String typename, int modifiers, String name, String descriptor, String signature) {
        super(modifiers, name, descriptor, signature);
        this.typename = typename;
    }

    public String getDeclaringTypeName() {
        return this.typename;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0x").append(Integer.toHexString(this.modifiers));
        sb.append(" ").append(this.descriptor).append(" ").append(this.name);
        if (this.signature != null) {
            sb.append(" [").append(this.signature).append("]");
        }
        return sb.toString().trim();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FieldMember)) {
            return false;
        }
        FieldMember o = (FieldMember)other;
        if (!this.name.equals(o.name)) {
            return false;
        }
        if (this.modifiers != o.modifiers) {
            return false;
        }
        if (!this.descriptor.equals(o.descriptor)) {
            return false;
        }
        if (this.signature == null && o.signature != null) {
            return false;
        }
        if (this.signature != null && o.signature == null) {
            return false;
        }
        return this.signature == null || this.signature.equals(o.signature);
    }

    public int hashCode() {
        int result = this.modifiers;
        result = result * 37 + this.name.hashCode();
        result = result * 37 + this.descriptor.hashCode();
        if (this.signature != null) {
            result = result * 37 + this.signature.hashCode();
        }
        return result;
    }
}

