/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.SystemClassReflectionGenerator;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class SystemClassReflectionRewriter {
    private static Logger log = Logger.getLogger(SystemClassReflectionRewriter.class.getName());

    public static RewriteResult rewrite(String slashedClassName, byte[] bytes) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("SystemClassReflectionRewriter running for " + slashedClassName);
        }
        ClassReader fileReader = new ClassReader(bytes);
        boolean is_jlObjectStream = slashedClassName.equals("java/io/ObjectStreamClass");
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor(is_jlObjectStream);
        fileReader.accept(classAdaptor, 4);
        return new RewriteResult(classAdaptor.getBytes(), classAdaptor.getBits());
    }

    static class RewriteClassAdaptor
    extends ClassVisitor
    implements Constants {
        private ClassWriter cw = (ClassWriter)this.cv;
        int bits = 0;
        private String classname;
        private boolean is_jlObjectStream;
        static Method m = null;

        private static boolean isInterceptable(String owner, String methodName) {
            String s = owner + "." + methodName;
            return MethodInvokerRewriter.RewriteClassAdaptor.intercepted.contains(s);
        }

        public RewriteClassAdaptor(boolean is_jlObjectStream) {
            super(327680, new ClassWriter(1));
            this.is_jlObjectStream = is_jlObjectStream;
            if (this.is_jlObjectStream) {
                this.bits |= 0x4000;
            }
        }

        public byte[] getBytes() {
            byte[] bytes = this.cw.toByteArray();
            return bytes;
        }

        public int getBits() {
            return this.bits;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classname = name;
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RewritingMethodAdapter(mv);
        }

        public void visitEnd() {
            this.addExtraMethodsAndFields();
            super.visitEnd();
        }

        private void addExtraMethodsAndFields() {
            if ((this.bits & 1) != 0) {
                SystemClassReflectionGenerator.generateJLCGDFS(this.cw, this.classname);
            }
            if ((this.bits & 2) != 0) {
                SystemClassReflectionGenerator.generateJLC(this.cw, this.classname, "getDeclaredField");
            }
            if ((this.bits & 4) != 0) {
                SystemClassReflectionGenerator.generateJLC(this.cw, this.classname, "getField");
            }
            if ((this.bits & 8) != 0) {
                SystemClassReflectionGenerator.generateJLCGetXXXMethods(this.cw, this.classname, "getDeclaredMethods");
            }
            if ((this.bits & 0x10) != 0) {
                SystemClassReflectionGenerator.generateJLCMethod(this.cw, this.classname, "getDeclaredMethod");
            }
            if ((this.bits & 0x20) != 0) {
                SystemClassReflectionGenerator.generateJLCMethod(this.cw, this.classname, "getMethod");
            }
            if ((this.bits & 0x80) != 0) {
                SystemClassReflectionGenerator.generateJLCGMODS(this.cw, this.classname);
            }
            if ((this.bits & 0x40) != 0) {
                SystemClassReflectionGenerator.generateJLCGDC(this.cw, this.classname);
            }
            if ((this.bits & 0x400) != 0) {
                SystemClassReflectionGenerator.generateJLC_GetDeclaredConstructors(this.cw, this.classname);
            }
            if ((this.bits & 0x100) != 0) {
                SystemClassReflectionGenerator.generateJLCGetXXXMethods(this.cw, this.classname, "getMethods");
            }
            if ((this.bits & 0x200) != 0) {
                SystemClassReflectionGenerator.generateJLCGC(this.cw, this.classname);
            }
            if ((this.bits & 0x800) != 0) {
                SystemClassReflectionGenerator.generateJLRM_Invoke(this.cw, this.classname);
            }
            if ((this.bits & 0x1000) != 0) {
                SystemClassReflectionGenerator.generateJLRF_Get(this.cw, this.classname);
            }
            if ((this.bits & 0x2000) != 0) {
                SystemClassReflectionGenerator.generateJLRF_GetLong(this.cw, this.classname);
            }
            if (this.is_jlObjectStream) {
                SystemClassReflectionGenerator.generateJLObjectStream_hasStaticInitializer(this.cw, this.classname);
            }
        }

        class RewritingMethodAdapter
        extends MethodVisitor
        implements Opcodes,
        Constants {
            int unitializedObjectsCount;

            public RewritingMethodAdapter(MethodVisitor mv) {
                super(327680, mv);
                this.unitializedObjectsCount = 0;
            }

            private boolean interceptReflection(String owner, String name, String desc) {
                if (RewriteClassAdaptor.isInterceptable(owner, name)) {
                    return this.callReflectiveInterceptor(owner, name, desc, this.mv);
                }
                return false;
            }

            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.rewriteReflectiveCall(opcode, owner, name, desc)) {
                    return;
                }
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }

            private boolean rewriteReflectiveCall(int opcode, String owner, String name, String desc) {
                if (owner.length() > 10 && owner.charAt(8) == 'g' && (owner.startsWith("java/lang/reflect/") || owner.equals("java/lang/Class"))) {
                    boolean rewritten = this.interceptReflection(owner, name, desc);
                    if (rewritten) {
                        return true;
                    }
                } else if (RewriteClassAdaptor.this.is_jlObjectStream && owner.equals(RewriteClassAdaptor.this.classname) && name.equals("hasStaticInitializer")) {
                    this.mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlos_him", desc);
                    return true;
                }
                return false;
            }

            private boolean callReflectiveInterceptor(String owner, String name, String desc, MethodVisitor mv) {
                if (owner.equals("java/lang/Class")) {
                    if (name.equals("getDeclaredFields")) {
                        RewriteClassAdaptor.this.bits |= 1;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdfs", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getDeclaredField")) {
                        RewriteClassAdaptor.this.bits |= 2;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getField")) {
                        RewriteClassAdaptor.this.bits |= 4;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getDeclaredMethods")) {
                        RewriteClassAdaptor.this.bits |= 8;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdms", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getDeclaredMethod")) {
                        RewriteClassAdaptor.this.bits |= 0x10;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdm", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getMethod")) {
                        RewriteClassAdaptor.this.bits |= 0x20;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgm", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getDeclaredConstructor")) {
                        RewriteClassAdaptor.this.bits |= 0x40;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdc", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
                        return true;
                    }
                    if (name.equals("getDeclaredConstructors")) {
                        RewriteClassAdaptor.this.bits |= 0x400;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdcs", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;");
                        return true;
                    }
                    if (name.equals("getConstructor")) {
                        RewriteClassAdaptor.this.bits |= 0x200;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgc", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
                        return true;
                    }
                    if (name.equals("getModifiers")) {
                        RewriteClassAdaptor.this.bits |= 0x80;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgmods", "(Ljava/lang/Class;)I");
                        return true;
                    }
                    if (name.equals("getMethods")) {
                        RewriteClassAdaptor.this.bits |= 0x100;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgms", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("newInstance")) {
                        return false;
                    }
                } else if (owner.equals("java/lang/reflect/Constructor")) {
                    if (name.equals("newInstance")) {
                        return false;
                    }
                } else if (owner.equals("java/lang/reflect/Method")) {
                    if (name.equals("invoke")) {
                        RewriteClassAdaptor.this.bits |= 0x800;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlrmi", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                        return true;
                    }
                } else if (owner.equals("java/lang/reflect/Field")) {
                    if (name.equals("get")) {
                        RewriteClassAdaptor.this.bits |= 0x1000;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlrfg", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;");
                        return true;
                    }
                    if (name.equals("getLong")) {
                        RewriteClassAdaptor.this.bits |= 0x2000;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlrfgl", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)J");
                        return true;
                    }
                }
                System.err.println("!!! SystemClassReflectionRewriter: nyi for " + owner + "." + name);
                return false;
            }
        }
    }

    public static class RewriteResult
    implements Constants {
        public final byte[] bytes;
        public final int bits;

        public RewriteResult(byte[] bytes, int bits) {
            this.bytes = bytes;
            this.bits = bits;
        }

        public String summarize() {
            StringBuilder s = new StringBuilder();
            s.append((this.bits & 0x400) != 0 ? "Class.getDeclaredConstructors()" : "");
            s.append((this.bits & 0x40) != 0 ? "Class.getDeclaredConstructor()" : "");
            s.append((this.bits & 0x200) != 0 ? "Class.getConstructor()" : "");
            s.append((this.bits & 0x80) != 0 ? "Class.getModifiers()" : "");
            s.append((this.bits & 1) != 0 ? "Class.getDeclaredFields() " : "");
            s.append((this.bits & 2) != 0 ? "Class.getDeclaredField() " : "");
            s.append((this.bits & 4) != 0 ? "Class.getField() " : "");
            s.append((this.bits & 8) != 0 ? "Class.getDeclaredMethods() " : "");
            s.append((this.bits & 0x10) != 0 ? "Class.getDeclaredMethod() " : "");
            s.append((this.bits & 0x20) != 0 ? "Class.getMethod() " : "");
            s.append((this.bits & 0x100) != 0 ? "Class.getMethods() " : "");
            s.append((this.bits & 0x800) != 0 ? "Method.invoke() " : "");
            s.append((this.bits & 0x1000) != 0 ? "Field.get() " : "");
            s.append((this.bits & 0x2000) != 0 ? "Field.getLong() " : "");
            s.append((this.bits & 0x4000) != 0 ? "jlObjectStream.hasStaticInitializer() " : "");
            return s.toString().trim();
        }
    }
}

