/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.IsReloadableTypePlugin;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;
import org.springsource.loaded.Log;
import org.springsource.loaded.Plugin;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.SystemClassReflectionRewriter;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import org.springsource.loaded.agent.CglibPlugin;
import org.springsource.loaded.agent.GroovyPlugin;
import org.springsource.loaded.agent.Impossible;
import org.springsource.loaded.agent.JVMPlugin;
import org.springsource.loaded.agent.SpringPlugin;
import org.springsource.loaded.ri.ReflectiveInterceptor;
import org.springsource.loaded.support.Java8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLoadedPreProcessor
implements Constants {
    private static Logger log = Logger.getLogger(SpringLoadedPreProcessor.class.getName());
    private static List<Plugin> plugins = null;
    public static boolean disabled = false;
    private static List<String> systemClassesContainingReflection;
    private Map<String, Integer> systemClassesRequiringInitialization = new HashMap<String, Integer>();
    private static boolean firstReloadableTypeHit;
    private static final Class<?> EMPTY_CLASS_ARRAY_CLAZZ;
    private static boolean prepared;
    private static Method method_jlcgdfs;
    private static Method method_jlcgdf;
    private static Method method_jlcgf;
    private static Method method_jlcgdms;
    private static Method method_jlcgdm;
    private static Method method_jlcgm;
    private static Method method_jlcgdc;
    private static Method method_jlcgc;
    private static Method method_jlcgmods;
    private static Method method_jlcgms;
    private static Method method_jlcgdcs;
    private static Method method_jlrfg;
    private static Method method_jlrfgl;
    private static Method method_jlrmi;
    private static Method method_jloObjectStream_hasInitializerMethod;
    private static List<IsReloadableTypePlugin> isReloadableTypePlugins;

    public void initialize() {
        GlobalConfiguration.directlyDefineTypes = false;
        GlobalConfiguration.fileSystemMonitoring = true;
        systemClassesContainingReflection = new ArrayList<String>();
        systemClassesContainingReflection.add("com/sun/xml/internal/bind/v2/model/nav/ReflectionNavigator");
        systemClassesContainingReflection.add("sun/misc/ProxyGenerator");
        systemClassesContainingReflection.add("java/lang/reflect/Proxy");
        systemClassesContainingReflection.add("java/beans/Introspector");
        systemClassesContainingReflection.add("java/io/ObjectStreamClass");
        systemClassesContainingReflection.add("java/io/ObjectStreamClass$EntryFuture");
    }

    public byte[] preProcess(ClassLoader classLoader, String slashedClassName, ProtectionDomain protectionDomain, byte[] bytes) {
        if (disabled) {
            return bytes;
        }
        for (Plugin plugin : SpringLoadedPreProcessor.getGlobalPlugins()) {
            LoadtimeInstrumentationPlugin loadtimeInstrumentationPlugin;
            if (!(plugin instanceof LoadtimeInstrumentationPlugin) || !(loadtimeInstrumentationPlugin = (LoadtimeInstrumentationPlugin)plugin).accept(slashedClassName, classLoader, protectionDomain, bytes)) continue;
            bytes = loadtimeInstrumentationPlugin.modify(slashedClassName, classLoader, bytes);
        }
        this.tryToEnsureSystemClassesInitialized(slashedClassName);
        TypeRegistry typeRegistry = TypeRegistry.getTypeRegistryFor(classLoader);
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
            this.logPreProcess(classLoader, slashedClassName, typeRegistry);
        }
        if (typeRegistry == null) {
            if (classLoader == null && slashedClassName != null) {
                if (systemClassesContainingReflection.contains(slashedClassName)) {
                    try {
                        SystemClassReflectionRewriter.RewriteResult rr = SystemClassReflectionRewriter.rewrite(slashedClassName, bytes);
                        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                            log.info("System class rewritten: name=" + slashedClassName + " rewrite summary=" + rr.summarize());
                        }
                        this.systemClassesRequiringInitialization.put(slashedClassName, rr.bits);
                        return rr.bytes;
                    }
                    catch (Exception re) {
                        re.printStackTrace();
                    }
                } else if (slashedClassName.equals("java/lang/invoke/InnerClassLambdaMetafactory")) {
                    bytes = Java8.enhanceInnerClassLambdaMetaFactory(bytes);
                    return bytes;
                }
            }
            return bytes;
        }
        boolean isReloadableTypeName = typeRegistry.isReloadableTypeName(slashedClassName, protectionDomain, bytes);
        if (isReloadableTypeName && GlobalConfiguration.explainMode && log.isLoggable(Level.INFO)) {
            log.info("[explanation] Based on the name, type " + slashedClassName + " is considered to be reloadable");
        }
        if (isReloadableTypeName) {
            if (!firstReloadableTypeHit) {
                firstReloadableTypeHit = true;
                this.tryToEnsureSystemClassesInitialized(slashedClassName);
            }
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("processing " + slashedClassName + " as a reloadable type");
            }
            try {
                ReloadableType rtype;
                String dottedClassName = slashedClassName.replace('/', '.');
                String watchPath = this.getWatchPathFromProtectionDomain(protectionDomain, slashedClassName);
                if (watchPath == null) {
                    String[] interfacesImplemented;
                    int proxyIndex;
                    int cglibIndex2;
                    boolean makeReloadableAnyway = false;
                    int cglibIndex = slashedClassName.indexOf("$$EnhancerBy");
                    if (cglibIndex != -1) {
                        String originalType = slashedClassName.substring(0, cglibIndex);
                        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                            log.info("Appears to be a CGLIB type, checking if type " + originalType + " is reloadable");
                        }
                        for (TypeRegistry currentRegistry = typeRegistry; currentRegistry != null; currentRegistry = currentRegistry.getParentRegistry()) {
                            ReloadableType originalReloadable = currentRegistry.getReloadableType(originalType);
                            if (originalReloadable == null) continue;
                            makeReloadableAnyway = true;
                            break;
                        }
                    }
                    int n = cglibIndex2 = makeReloadableAnyway ? -1 : slashedClassName.indexOf("$$FastClassByCGLIB");
                    if (cglibIndex2 != -1) {
                        String originalType = slashedClassName.substring(0, cglibIndex2);
                        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                            log.info("Appears to be a CGLIB FastClass type, checking if type " + originalType + " is reloadable");
                        }
                        for (TypeRegistry currentRegistry = typeRegistry; currentRegistry != null; currentRegistry = currentRegistry.getParentRegistry()) {
                            ReloadableType originalReloadable = currentRegistry.getReloadableType(originalType);
                            if (originalReloadable == null) continue;
                            makeReloadableAnyway = true;
                            break;
                        }
                    }
                    int n2 = proxyIndex = makeReloadableAnyway ? -1 : slashedClassName.indexOf("$Proxy");
                    if ((proxyIndex == 0 || proxyIndex > 0 && slashedClassName.charAt(proxyIndex - 1) == '/') && (interfacesImplemented = Utils.discoverInterfaces(bytes)) != null) {
                        block9: for (int i = 0; i < interfacesImplemented.length; ++i) {
                            for (TypeRegistry currentRegistry = typeRegistry; currentRegistry != null; currentRegistry = currentRegistry.getParentRegistry()) {
                                ReloadableType originalReloadable = currentRegistry.getReloadableType(interfacesImplemented[i]);
                                if (originalReloadable == null) continue;
                                makeReloadableAnyway = true;
                                continue block9;
                            }
                        }
                    }
                    if (!makeReloadableAnyway && classLoader.getClass().getName().endsWith("GroovyClassLoader$InnerLoader")) {
                        makeReloadableAnyway = true;
                    }
                    if (!makeReloadableAnyway) {
                        if (GlobalConfiguration.verboseMode) {
                            Log.log("Cannot watch " + slashedClassName + ": not making it reloadable");
                        }
                        if (SpringLoadedPreProcessor.needsClientSideRewriting(slashedClassName)) {
                            bytes = typeRegistry.methodCallRewriteUseCacheIfAvailable(slashedClassName, bytes);
                        }
                        return bytes;
                    }
                }
                if ((rtype = typeRegistry.addType(dottedClassName, bytes)) != null || !GlobalConfiguration.callsideRewritingOn) {
                    if (GlobalConfiguration.fileSystemMonitoring && watchPath != null) {
                        typeRegistry.monitorForUpdates(rtype, watchPath);
                    }
                    return rtype.bytesLoaded;
                }
                bytes = typeRegistry.methodCallRewrite(bytes);
            }
            catch (RuntimeException re) {
                log.throwing("SpringLoadedPreProcessor", "preProcess", re);
                throw re;
            }
        }
        try {
            if (SpringLoadedPreProcessor.needsClientSideRewriting(slashedClassName)) {
                bytes = typeRegistry.methodCallRewriteUseCacheIfAvailable(slashedClassName, bytes);
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Unexpected problem transforming call sites", t);
        }
        return bytes;
    }

    private void tryToEnsureSystemClassesInitialized(String slashedClassName) {
        if (firstReloadableTypeHit && !this.systemClassesRequiringInitialization.isEmpty()) {
            int lastSlash = slashedClassName.lastIndexOf(47);
            String pkg = lastSlash == -1 ? null : slashedClassName.substring(0, lastSlash);
            this.ensurePreparedForInjection();
            ArrayList<String> toRemoveList = new ArrayList<String>();
            for (Map.Entry<String, Integer> me : this.systemClassesRequiringInitialization.entrySet()) {
                String classname = me.getKey();
                if (pkg != null && classname.startsWith(pkg)) continue;
                int bits = me.getValue();
                try {
                    Class<?> clazz = SpringLoadedPreProcessor.class.getClassLoader().loadClass(classname.replace('/', '.'));
                    this.injectReflectiveInterceptorMethods(slashedClassName, bits, clazz);
                    toRemoveList.add(classname);
                }
                catch (ClassCircularityError cce) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String toRemove : toRemoveList) {
                this.systemClassesRequiringInitialization.remove(toRemove);
            }
        }
    }

    private void injectReflectiveInterceptorMethods(String slashedClassName, int bits, Class<?> clazz) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException {
        Field f;
        if ((bits & 1) != 0) {
            f = clazz.getDeclaredField("__sljlcgdfs");
            f.setAccessible(true);
            f.set(null, method_jlcgdfs);
        }
        if ((bits & 2) != 0) {
            f = clazz.getDeclaredField("__sljlcgdf");
            f.setAccessible(true);
            f.set(null, method_jlcgdf);
        }
        if ((bits & 4) != 0) {
            f = clazz.getDeclaredField("__sljlcgf");
            f.setAccessible(true);
            f.set(null, method_jlcgf);
        }
        if ((bits & 8) != 0) {
            f = clazz.getDeclaredField("__sljlcgdms");
            f.setAccessible(true);
            f.set(null, method_jlcgdms);
        }
        if ((bits & 0x10) != 0) {
            f = clazz.getDeclaredField("__sljlcgdm");
            f.setAccessible(true);
            f.set(null, method_jlcgdm);
        }
        if ((bits & 0x20) != 0) {
            f = clazz.getDeclaredField("__sljlcgm");
            f.setAccessible(true);
            f.set(null, method_jlcgm);
        }
        if ((bits & 0x40) != 0) {
            f = clazz.getDeclaredField("__sljlcgdc");
            f.setAccessible(true);
            f.set(null, method_jlcgdc);
        }
        if ((bits & 0x80) != 0) {
            f = clazz.getDeclaredField("__sljlcgmods");
            f.setAccessible(true);
            f.set(null, method_jlcgmods);
        }
        if ((bits & 0x100) != 0) {
            f = clazz.getDeclaredField("__sljlcgms");
            f.setAccessible(true);
            f.set(null, method_jlcgms);
        }
        if ((bits & 0x200) != 0) {
            f = clazz.getDeclaredField("__sljlcgc");
            f.setAccessible(true);
            f.set(null, method_jlcgc);
        }
        if ((bits & 0x400) != 0) {
            f = clazz.getDeclaredField("__sljlcgdcs");
            f.setAccessible(true);
            f.set(null, method_jlcgdcs);
        }
        if ((bits & 0x1000) != 0) {
            f = clazz.getDeclaredField("__sljlrfg");
            f.setAccessible(true);
            f.set(null, method_jlrfg);
        }
        if ((bits & 0x2000) != 0) {
            f = clazz.getDeclaredField("__sljlrfgl");
            f.setAccessible(true);
            f.set(null, method_jlrfgl);
        }
        if ((bits & 0x800) != 0) {
            f = clazz.getDeclaredField("__sljlrmi");
            f.setAccessible(true);
            f.set(null, method_jlrmi);
        }
        if ((bits & 0x4000) != 0) {
            f = clazz.getDeclaredField("__sljlos_him");
            f.setAccessible(true);
            f.set(null, method_jloObjectStream_hasInitializerMethod);
        }
    }

    private void ensurePreparedForInjection() {
        if (!prepared) {
            try {
                Class<ReflectiveInterceptor> clazz = ReflectiveInterceptor.class;
                method_jlcgdfs = clazz.getDeclaredMethod("jlClassGetDeclaredFields", Class.class);
                method_jlcgdf = clazz.getDeclaredMethod("jlClassGetDeclaredField", Class.class, String.class);
                method_jlcgf = clazz.getDeclaredMethod("jlClassGetField", Class.class, String.class);
                method_jlcgdms = clazz.getDeclaredMethod("jlClassGetDeclaredMethods", Class.class);
                method_jlcgdm = clazz.getDeclaredMethod("jlClassGetDeclaredMethod", Class.class, String.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgm = clazz.getDeclaredMethod("jlClassGetMethod", Class.class, String.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgdc = clazz.getDeclaredMethod("jlClassGetDeclaredConstructor", Class.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgc = clazz.getDeclaredMethod("jlClassGetConstructor", Class.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgmods = clazz.getDeclaredMethod("jlClassGetModifiers", Class.class);
                method_jlcgms = clazz.getDeclaredMethod("jlClassGetMethods", Class.class);
                method_jlcgdcs = clazz.getDeclaredMethod("jlClassGetDeclaredConstructors", Class.class);
                method_jlrfg = clazz.getDeclaredMethod("jlrFieldGet", Field.class, Object.class);
                method_jlrfgl = clazz.getDeclaredMethod("jlrFieldGetLong", Field.class, Object.class);
                method_jlrmi = clazz.getDeclaredMethod("jlrMethodInvoke", Method.class, Object.class, Object[].class);
                method_jloObjectStream_hasInitializerMethod = clazz.getDeclaredMethod("jlosHasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new Impossible(nsme);
            }
            prepared = true;
        }
    }

    private static boolean needsClientSideRewriting(String slashedClassName) {
        return slashedClassName == null || slashedClassName.charAt(0) != 'o' || !slashedClassName.startsWith("org/springsource/loaded");
    }

    private String getWatchPathFromProtectionDomain(ProtectionDomain protectionDomain, String slashedClassName) {
        String watchPath;
        block23: {
            watchPath = null;
            if (protectionDomain == null) {
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.WARNING)) {
                    log.warning("Changes to type cannot be tracked: " + slashedClassName + " - no protection domain");
                }
            } else {
                try {
                    File file;
                    block24: {
                        CodeSource codeSource = protectionDomain.getCodeSource();
                        if (codeSource.getLocation() == null) {
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.WARNING)) {
                                log.warning("null codesource for " + slashedClassName);
                            }
                            break block23;
                        }
                        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                            log.finest("Codesource.getLocation()=" + codeSource.getLocation());
                        }
                        file = null;
                        URI uri = null;
                        try {
                            uri = codeSource.getLocation().toURI();
                            file = new File(uri);
                        }
                        catch (IllegalArgumentException iae) {
                            boolean recovered = false;
                            if (iae.toString().indexOf("URI is not hierarchical") != -1) {
                                String uristring = uri.toString();
                                if (uristring.startsWith("file:../")) {
                                    file = new File(uristring.substring(8)).getAbsoluteFile();
                                } else if (uristring.startsWith("file:./")) {
                                    file = new File(uristring.substring(7)).getAbsoluteFile();
                                }
                                if (file != null && file.exists()) {
                                    recovered = true;
                                }
                            }
                            if (recovered) break block24;
                            System.out.println("Unable to watch file: classname = " + slashedClassName + " codesource location = " + codeSource.getLocation() + " ex = " + iae.toString());
                            return null;
                        }
                    }
                    if (file.isDirectory()) {
                        file = new File(file, slashedClassName + ".class");
                    } else if (!file.getName().endsWith(".class")) {
                        if (file.getName().endsWith(".jar")) {
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.WARNING)) {
                                log.warning("unable to watch this jar file entry: " + slashedClassName.replace('/', '.') + ". Computed location=" + file.toString());
                            }
                            return null;
                        }
                        if (file.toString().equals("/groovy/script") || file.toString().equals("\\groovy\\script")) {
                            return null;
                        }
                        if (!file.toString().endsWith(".class")) {
                            return null;
                        }
                        throw new UnsupportedOperationException("unable to watch " + slashedClassName.replace('/', '.') + ". Computed location=" + file.toString());
                    }
                    watchPath = file.toString();
                    if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                        log.info("Watched location for changes to " + slashedClassName + " is " + watchPath);
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Unexpected problem processing URI ", e);
                }
            }
        }
        return watchPath;
    }

    private void logPreProcess(ClassLoader classLoader, String slashedClassName, TypeRegistry typeRegistry) {
        String clname;
        String string = clname = classLoader == null ? "null" : classLoader.getClass().getName();
        if (clname.indexOf(46) != -1) {
            clname = clname.substring(clname.lastIndexOf(46) + 1);
        }
        log.info("SpringLoaded preprocessing: classname=" + slashedClassName + " classloader=" + clname + " typeRegistry=" + typeRegistry);
    }

    public static List<Plugin> getGlobalPlugins() {
        if (plugins == null) {
            plugins = new ArrayList<Plugin>();
            plugins.add(new JVMPlugin());
            plugins.add(new SpringPlugin());
            plugins.add(new GroovyPlugin());
            plugins.add(new CglibPlugin());
            List<String> extraGlobalPlugins = GlobalConfiguration.pluginClassnameList;
            if (extraGlobalPlugins != null) {
                for (String globalPlugin : extraGlobalPlugins) {
                    try {
                        Class<?> pluginClass = Class.forName(globalPlugin, false, SpringLoadedPreProcessor.class.getClassLoader());
                        plugins.add((Plugin)pluginClass.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                    catch (InstantiationException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<IsReloadableTypePlugin> getIsReloadableTypePlugins() {
        if (isReloadableTypePlugins != null) return isReloadableTypePlugins;
        Class<SpringLoadedPreProcessor> clazz = SpringLoadedPreProcessor.class;
        synchronized (SpringLoadedPreProcessor.class) {
            if (isReloadableTypePlugins != null) return isReloadableTypePlugins;
            isReloadableTypePlugins = new ArrayList<IsReloadableTypePlugin>();
            for (Plugin p : SpringLoadedPreProcessor.getGlobalPlugins()) {
                if (!(p instanceof IsReloadableTypePlugin)) continue;
                isReloadableTypePlugins.add((IsReloadableTypePlugin)p);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return isReloadableTypePlugins;
        }
    }

    public static void registerGlobalPlugin(Plugin instance) {
        SpringLoadedPreProcessor.getGlobalPlugins();
        plugins.add(instance);
        isReloadableTypePlugins = null;
    }

    public static void unregisterGlobalPlugin(Plugin instance) {
        SpringLoadedPreProcessor.getGlobalPlugins();
        plugins.remove(instance);
        isReloadableTypePlugins = null;
    }

    static {
        firstReloadableTypeHit = false;
        EMPTY_CLASS_ARRAY_CLAZZ = Class[].class;
        prepared = false;
        isReloadableTypePlugins = null;
    }
}

