/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.ArchetypeDescriptorException;
import org.apache.maven.archetype.old.ArchetypeNotFoundException;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class MavenArchetypeMojo
extends AbstractMojo {
    private OldArchetype archetype;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    private ArtifactRepository localRepository;
    private String archetypeGroupId;
    private String archetypeArtifactId;
    private String archetypeVersion;
    private String groupId;
    private String artifactId;
    private String version;
    private String packageName;
    private List<ArtifactRepository> pomRemoteRepositories;
    private String remoteRepositories;
    private MavenProject project;
    private String basedir;

    public void execute() throws MojoExecutionException {
        this.getLog().warn((CharSequence)"This goal is deprecated. Please use mvn archetype:generate instead");
        if (this.project.getFile() != null && this.groupId == null) {
            this.groupId = this.project.getGroupId();
        }
        if (this.packageName == null) {
            this.getLog().info((CharSequence)("Defaulting package to group ID: " + this.groupId));
            this.packageName = this.groupId;
        }
        ArrayList<Object> archetypeRemoteRepositories = new ArrayList<ArtifactRepository>(this.pomRemoteRepositories);
        if (this.remoteRepositories != null) {
            this.getLog().info((CharSequence)("We are using command line specified remote repositories: " + this.remoteRepositories));
            archetypeRemoteRepositories = new ArrayList();
            String[] s = StringUtils.split((String)this.remoteRepositories, (String)",");
            for (int i = 0; i < s.length; ++i) {
                archetypeRemoteRepositories.add(this.createRepository(s[i], "id" + i));
            }
        }
        try {
            ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setPackage(this.packageName).setGroupId(this.groupId).setArtifactId(this.artifactId).setVersion(this.version).setArchetypeGroupId(this.archetypeGroupId).setArchetypeArtifactId(this.archetypeArtifactId).setArchetypeVersion(this.archetypeVersion).setLocalRepository(this.localRepository).setRemoteArtifactRepositories(archetypeRemoteRepositories).setOutputDirectory(this.basedir);
            this.archetype.createArchetype(request, this.createRepository("http://repo1.maven.org/maven2", "central"));
        }
        catch (UnknownArchetype e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
        catch (ArchetypeNotFoundException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
        catch (ArchetypeDescriptorException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
        catch (ArchetypeTemplateProcessingException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
    }

    private ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }
}

