/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.SPARQLUtil;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTString;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class StringEscapesProcessor {
    public static void process(ASTOperationContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
    }

    private static class StringProcessor
    extends ASTVisitorBase {
        public Object visit(ASTString stringNode, Object data) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SPARQLUtil.decodeString(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(stringNode, data);
        }
    }
}

