/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.base;

import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;

public abstract class RepositoryBase
implements Repository {
    private boolean initialized = false;
    private final Object initLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() throws RepositoryException {
        if (!this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    this.initializeInternal();
                    this.initialized = true;
                }
            }
        }
    }

    protected abstract void initializeInternal() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutDown() throws RepositoryException {
        Object object = this.initLock;
        synchronized (object) {
            this.shutDownInternal();
            this.initialized = false;
        }
    }

    public final synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void shutDownInternal() throws RepositoryException;
}

