/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.text;

import java.util.ArrayList;

public class StringUtil {
    private static final int MIN_INITIAL_TEXT_LENGTH = 3;
    private static final int MAX_INITIAL_TEXT_LENGTH = 250;

    public static String gsub(String olds, String news, String text) {
        if (olds == null || olds.length() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        int oldsIndex = text.indexOf(olds);
        if (oldsIndex == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int prevIndex = 0;
        while (oldsIndex >= 0) {
            buf.append(text.substring(prevIndex, oldsIndex));
            buf.append(news);
            prevIndex = oldsIndex + olds.length();
            oldsIndex = text.indexOf(olds, prevIndex);
        }
        buf.append(text.substring(prevIndex));
        return buf.toString();
    }

    public static String getAllAfter(String string, char separatorChar) {
        int index = string.indexOf(separatorChar);
        if (index < 0 || index == string.length() - 1) {
            return string;
        }
        return string.substring(index + 1);
    }

    public static String getAllBefore(String string, char separatorChar) {
        int index = string.indexOf(separatorChar);
        return index <= 0 ? string : string.substring(0, index - 1);
    }

    public static String encodeArray(String[] array) {
        StringBuilder buffer = new StringBuilder();
        int nrItems = array.length;
        int i = 0;
        while (i < nrItems) {
            String item = array[i];
            item = StringUtil.gsub("_", "__", item);
            buffer.append(item);
            if (i < nrItems - 1) {
                buffer.append("_.");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] decodeArray(String encodedArray) {
        String[] items = encodedArray.split("_\\.");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (!(item = StringUtil.gsub("__", "_", item)).equals("")) {
                list.add(item);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String deriveInitialText(String text) {
        String result = null;
        int startIdx = 0;
        int endIdx = 0;
        int textLength = text.length();
        while (startIdx < textLength && result == null) {
            String candidateText;
            startIdx = endIdx;
            while (startIdx < textLength && !StringUtil.isInitialTextStartChar(text.charAt(startIdx))) {
                ++startIdx;
            }
            endIdx = startIdx + 1;
            while (endIdx < textLength && endIdx - startIdx < 250 && StringUtil.isInitialTextChar(text.charAt(endIdx))) {
                ++endIdx;
            }
            if (endIdx - startIdx < 3 || StringUtil.isGarbageText(candidateText = text.substring(startIdx, endIdx).trim())) continue;
            result = candidateText;
        }
        return result;
    }

    public static boolean isGarbageText(String text) {
        boolean result = false;
        if (text.trim().length() < 3) {
            result = true;
        } else if (text.length() > 30) {
            result = true;
            int i = 0;
            while (i < text.length()) {
                if (Character.getType(text.charAt(i)) == 12) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static void appendN(char c, int n, StringBuilder sb) {
        int i = n;
        while (i > 0) {
            sb.append(c);
            --i;
        }
    }

    public static String trimDoubleQuotes(String text) {
        int textLength = text.length();
        if (textLength >= 2 && text.charAt(0) == '\"' && text.charAt(textLength - 1) == '\"') {
            return text.substring(1, textLength - 1);
        }
        return text;
    }

    private static boolean isInitialTextStartChar(char c) {
        int charType = Character.getType(c);
        return charType == 1 || charType == 2 || charType == 3 || charType == 4 || charType == 5 || charType == 9 || charType == 21 || charType == 29;
    }

    private static boolean isInitialTextChar(char c) {
        int charType = Character.getType(c);
        return charType == 1 || charType == 2 || charType == 3 || charType == 4 || charType == 5 || charType == 9 || charType == 12 || charType == 23 || charType == 20 || charType == 21 || charType == 22 || charType == 29 || charType == 30 || charType == 24;
    }

    public static String concat(String ... strings) {
        int totalLength = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            totalLength += s.length();
            ++n2;
        }
        StringBuilder result = new StringBuilder(totalLength);
        String[] stringArray2 = strings;
        int n3 = strings.length;
        n = 0;
        while (n < n3) {
            String string = stringArray2[n];
            result.append(string);
            ++n;
        }
        return result.toString();
    }
}

