/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import virtuoso.jena.driver.VirtDataSource;
import virtuoso.jena.driver.VirtGraph;

public class VirtQueryEngine
extends QueryEngineMain {
    private Query eQuery = null;
    int prefetchSize = 200;
    static QueryEngineFactory factory = new VirtQueryEngineFactory();

    public VirtQueryEngine(Query query, DatasetGraph datasetGraph, Binding binding, Context context) {
        super(query, datasetGraph, binding, context);
        this.eQuery = query;
    }

    public VirtQueryEngine(Query query, DatasetGraph datasetGraph) {
        this(query, datasetGraph, null, null);
    }

    public QueryIterator eval(Op op, DatasetGraph datasetGraph, Binding binding, Context context) {
        VirtTransform virtTransform = new VirtTransform();
        op = Transformer.transform((Transform)virtTransform, (Op)op);
        VirtGraph virtGraph = (VirtGraph)datasetGraph.getDefaultGraph();
        String string = "sparql\n define output:format '_JAVA_'\n " + this.eQuery;
        this.prefetchSize = virtGraph.getFetchSize();
        try {
            Connection connection = virtGraph.getConnection();
            Statement statement = connection.createStatement();
            statement.setFetchSize(this.prefetchSize);
            ResultSet resultSet = statement.executeQuery(string);
            return new VQueryIterator(virtGraph, resultSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JenaException("Can not create QueryIterator.:" + exception);
        }
    }

    protected Op modifyOp(Op op) {
        op = super.modifyOp(op);
        return op;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    protected class VQueryIterator
    extends QueryIteratorBase {
        ResultSetMetaData rsmd;
        ResultSet rs;
        VirtGraph vg;
        boolean v_finished = false;
        boolean v_prefetched = false;
        Binding v_row;
        String virt_graph = null;

        protected VQueryIterator(VirtGraph virtGraph, ResultSet resultSet) {
            this.rs = resultSet;
            this.vg = virtGraph;
            this.virt_graph = this.vg.getGraphName();
            try {
                this.rsmd = this.rs.getMetaData();
            }
            catch (Exception exception) {
                throw new JenaException("VQueryIterator is FAILED.:" + exception);
            }
        }

        public void output(IndentedWriter indentedWriter, SerializationContext serializationContext) {
            indentedWriter.print((Object)Utils.className((Object)((Object)this)));
        }

        protected boolean hasNextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        protected Binding moveToNextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                return null;
            }
            return this.v_row;
        }

        protected void closeIterator() {
            if (!this.v_finished && this.rs != null) {
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.v_finished = true;
        }

        protected void moveForward() throws JenaException {
            try {
                if (!this.v_finished && this.rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.closeIterator();
                }
            }
            catch (Exception exception) {
                throw new JenaException("Convert results are FAILED.:" + exception);
            }
        }

        protected void extractRow() throws Exception {
            this.v_row = new BindingMap();
            try {
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    this.v_row.add(Var.alloc((String)this.rsmd.getColumnLabel(i)), VirtGraph.Object2Node(this.rs.getObject(i)));
                }
                if (this.virt_graph != null && !this.virt_graph.equals("virt:DEFAULT")) {
                    this.v_row.add(Var.alloc((String)"graph"), Node.createURI((String)this.virt_graph));
                }
            }
            catch (Exception exception) {
                throw new JenaException("extractRow is FAILED.:" + exception);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class VirtQueryEngineFactory
    implements QueryEngineFactory {
        private VirtQueryEngineFactory() {
        }

        public boolean accept(Query query, DatasetGraph datasetGraph, Context context) {
            if (datasetGraph instanceof VirtDataSource.VirtDataSetGraph) {
                return true;
            }
            return datasetGraph.getDefaultGraph() instanceof VirtGraph;
        }

        public Plan create(Query query, DatasetGraph datasetGraph, Binding binding, Context context) {
            if (!(datasetGraph instanceof VirtDataSource.VirtDataSetGraph) && !(datasetGraph.getDefaultGraph() instanceof VirtGraph)) {
                throw new ARQInternalErrorException("VirtQueryEngineFactory: only factory VirtuosoDatasetGraph is supported");
            }
            VirtQueryEngine virtQueryEngine = new VirtQueryEngine(query, datasetGraph, binding, context);
            return virtQueryEngine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph datasetGraph, Context context) {
            return false;
        }

        public Plan create(Op op, DatasetGraph datasetGraph, Binding binding, Context context) {
            throw new ARQInternalErrorException("VirtQueryEngineFactory: factory calleddirectly with an algebra expression");
        }
    }

    private class VirtTransform
    extends TransformCopy {
        private VirtTransform() {
        }

        public Op transform(OpBGP opBGP) {
            return opBGP;
        }
    }
}

