/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.datetime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Tz
implements Function {
    public String getURI() {
        return "TZ";
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("TZ requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            URI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isCalendarDatatype((URI)datatype)) {
                String lexValue = literal.getLabel();
                Pattern pattern = Pattern.compile("Z|[+-]\\d\\d:\\d\\d");
                Matcher m = pattern.matcher(lexValue);
                String timeZone = "";
                if (m.find()) {
                    timeZone = m.group();
                }
                return valueFactory.createLiteral(timeZone);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

