/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Ceil
implements Function {
    public String getURI() {
        return FN.NUMERIC_CEIL.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("CEIL requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isNumericDatatype((URI)datatype)) {
                if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isDecimalDatatype((URI)datatype)) {
                    BigDecimal ceilingValue = literal.decimalValue().setScale(0, RoundingMode.CEILING);
                    return valueFactory.createLiteral(ceilingValue.toPlainString(), datatype);
                }
                if (XMLDatatypeUtil.isFloatingPointDatatype((URI)datatype)) {
                    double ceilingValue = Math.ceil(literal.doubleValue());
                    return valueFactory.createLiteral(Double.toString(ceilingValue), datatype);
                }
                throw new ValueExprEvaluationException("unexpected datatype for function operand: " + args[0]);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

