/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTPrefixDecl;
import org.openrdf.query.parser.sparql.ast.ASTQName;
import org.openrdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.openrdf.query.parser.sparql.ast.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixDeclProcessor {
    public static Map<String, String> process(ASTOperationContainer qc) throws MalformedQueryException {
        List<ASTPrefixDecl> prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl prefixDecl : prefixDeclList) {
            String prefix = prefixDecl.getPrefix();
            String iri = prefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(prefix)) {
                throw new MalformedQueryException("Multiple prefix declarations for prefix '" + prefix + "'");
            }
            prefixMap.put(prefix, iri);
        }
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "sesame", "http://www.openrdf.org/schema/sesame#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "owl", "http://www.w3.org/2002/07/owl#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "xsd", "http://www.w3.org/2001/XMLSchema#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "fn", "http://www.w3.org/2005/xpath-functions#");
        QNameProcessor visitor = new QNameProcessor(prefixMap);
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
        return prefixMap;
    }

    private static void insertDefaultPrefix(Map<String, String> prefixMap, String prefix, String namespace) {
        if (!prefixMap.containsKey(prefix) && !prefixMap.containsValue(namespace)) {
            prefixMap.put(prefix, namespace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QNameProcessor
    extends ASTVisitorBase {
        private Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            localName = this.processEscapesAndHex(localName);
            ASTIRI iriNode = new ASTIRI(43);
            iriNode.setValue(String.valueOf(namespace) + localName);
            qnameNode.jjtReplaceWith(iriNode);
            return null;
        }

        private String processEscapesAndHex(String localName) {
            StringBuffer unencoded = new StringBuffer();
            Pattern hexPattern = Pattern.compile("([^\\\\]|^)(%[A-F\\d][A-F\\d])", 2);
            Matcher m = hexPattern.matcher(localName);
            boolean result = m.find();
            while (result) {
                String previousChar = m.group(1);
                String encoded = m.group(2);
                int codePoint = Integer.parseInt(encoded.substring(1), 16);
                String decoded = String.valueOf(Character.toChars(codePoint));
                m.appendReplacement(unencoded, String.valueOf(previousChar) + decoded);
                result = m.find();
            }
            m.appendTail(unencoded);
            StringBuffer unescaped = new StringBuffer();
            Pattern escapedCharPattern = Pattern.compile("\\\\[_~\\.\\-!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\/\\?#\\@\\%]");
            m = escapedCharPattern.matcher(unencoded.toString());
            result = m.find();
            while (result) {
                String escaped = m.group();
                m.appendReplacement(unescaped, escaped.substring(1));
                result = m.find();
            }
            m.appendTail(unescaped);
            return unescaped.toString();
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }
    }
}

