/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.optimizers;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.BNodeColumn;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.DatatypeColumn;
import org.openrdf.sail.rdbms.algebra.IdColumn;
import org.openrdf.sail.rdbms.algebra.JoinItem;
import org.openrdf.sail.rdbms.algebra.LabelColumn;
import org.openrdf.sail.rdbms.algebra.LanguageColumn;
import org.openrdf.sail.rdbms.algebra.LongLabelColumn;
import org.openrdf.sail.rdbms.algebra.LongURIColumn;
import org.openrdf.sail.rdbms.algebra.NumberValue;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SelectProjection;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.algebra.SqlEq;
import org.openrdf.sail.rdbms.algebra.SqlOr;
import org.openrdf.sail.rdbms.algebra.URIColumn;
import org.openrdf.sail.rdbms.algebra.UnionItem;
import org.openrdf.sail.rdbms.algebra.base.BinarySqlOperator;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.SqlExprFactory;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.RdbmsRuntimeException;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.managers.TransTableManager;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.schema.IdSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQueryOptimizer
extends RdbmsQueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    private static final String ALIAS = "t";
    private SqlExprFactory sql;
    private int aliasCount = 0;
    private BindingSet bindings;
    private Dataset dataset;
    private RdbmsValueFactory vf;
    private TransTableManager tables;
    private IdSequence ids;

    public void setSqlExprFactory(SqlExprFactory sql) {
        this.sql = sql;
    }

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public void setTransTableManager(TransTableManager statements) {
        this.tables = statements;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        this.dataset = dataset;
        this.bindings = bindings;
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Distinct node) throws RuntimeException {
        super.meet(node);
        if (node.getArg() instanceof SelectQuery) {
            SelectQuery query = (SelectQuery)node.getArg();
            query.setDistinct(true);
            node.replaceWith((QueryModelNode)query);
        }
    }

    public void meet(Union node) throws RuntimeException {
        super.meet(node);
        TupleExpr l = node.getLeftArg();
        TupleExpr r = node.getRightArg();
        if (!(l instanceof SelectQuery) || !(r instanceof SelectQuery)) {
            return;
        }
        SelectQuery left = (SelectQuery)l;
        SelectQuery right = (SelectQuery)r;
        if (left.isComplex() || right.isComplex()) {
            return;
        }
        UnionItem union = new UnionItem("u" + this.aliasCount++);
        union.addUnion(left.getFrom().clone());
        union.addUnion(right.getFrom().clone());
        SelectQuery query = new SelectQuery();
        query.setFrom(union);
        this.mergeSelectClause(query, left);
        this.mergeSelectClause(query, right);
        this.addProjectionsFromUnion(query, union);
        node.replaceWith((QueryModelNode)query);
    }

    private void addProjectionsFromUnion(SelectQuery query, UnionItem union) {
        for (ColumnVar var : union.getSelectColumns()) {
            if (query.hasSqlSelectVarName(var.getName())) continue;
            SelectProjection proj = new SelectProjection();
            proj.setVar(var);
            proj.setId(new RefIdColumn(var));
            proj.setStringValue(SqlExprSupport.coalesce(new URIColumn(var), new BNodeColumn(var), new LabelColumn(var), new LongLabelColumn(var), new LongURIColumn(var)));
            proj.setDatatype(new DatatypeColumn(var));
            proj.setLanguage(new LanguageColumn(var));
            query.addSqlSelectVar(proj);
        }
    }

    public void meet(Join node) throws RuntimeException {
        super.meet(node);
        TupleExpr l = node.getLeftArg();
        TupleExpr r = node.getRightArg();
        if (!(l instanceof SelectQuery) || !(r instanceof SelectQuery)) {
            return;
        }
        SelectQuery left = (SelectQuery)l;
        SelectQuery right = (SelectQuery)r;
        if (left.isComplex() || right.isComplex()) {
            return;
        }
        left = left.clone();
        right = right.clone();
        this.filterOn(left, right);
        this.mergeSelectClause(left, right);
        left.addJoin(right);
        node.replaceWith((QueryModelNode)left);
    }

    public void meet(LeftJoin node) throws RuntimeException {
        super.meet(node);
        TupleExpr l = node.getLeftArg();
        TupleExpr r = node.getRightArg();
        if (!(l instanceof SelectQuery) || !(r instanceof SelectQuery)) {
            return;
        }
        SelectQuery left = (SelectQuery)l;
        SelectQuery right = (SelectQuery)r;
        if (left.isComplex() || right.isComplex()) {
            return;
        }
        left = left.clone();
        right = right.clone();
        this.filterOn(left, right);
        this.mergeSelectClause(left, right);
        left.addLeftJoin(right);
        ArrayList<SqlExpr> filters = new ArrayList<SqlExpr>();
        if (node.getCondition() != null) {
            for (ValueExpr expr : this.flatten(node.getCondition())) {
                try {
                    filters.add(this.sql.createBooleanExpr(expr));
                }
                catch (UnsupportedRdbmsOperatorException e) {
                    return;
                }
            }
        }
        for (SqlExpr filter : filters) {
            right.addFilter(filter);
        }
        node.replaceWith((QueryModelNode)left);
    }

    public void meet(StatementPattern sp) {
        boolean present;
        String tableName;
        super.meet(sp);
        Var subjVar = sp.getSubjectVar();
        Var predVar = sp.getPredicateVar();
        Var objVar = sp.getObjectVar();
        Var ctxVar = sp.getContextVar();
        Value subjValue = this.getVarValue(subjVar, this.bindings);
        Value predValue = this.getVarValue(predVar, this.bindings);
        Value objValue = this.getVarValue(objVar, this.bindings);
        Value ctxValue = this.getVarValue(ctxVar, this.bindings);
        if (subjValue instanceof Literal || predValue instanceof Literal || predValue instanceof BNode || ctxValue instanceof Literal) {
            return;
        }
        Resource[] contexts = this.getContexts(sp, ctxValue);
        if (contexts == null) {
            return;
        }
        String alias = this.getTableAlias(predValue) + this.aliasCount++;
        Number predId = this.getInternalId(predValue);
        try {
            tableName = this.tables.getTableName(predId);
            present = this.tables.isPredColumnPresent(predId);
        }
        catch (SQLException e) {
            throw new RdbmsRuntimeException(e);
        }
        JoinItem from = new JoinItem(alias, tableName, predId);
        ColumnVar s = ColumnVar.createSubj(alias, subjVar, (Resource)subjValue);
        ColumnVar p = ColumnVar.createPred(alias, predVar, (URI)predValue, !present);
        ColumnVar o = ColumnVar.createObj(alias, objVar, objValue);
        ColumnVar c = ColumnVar.createCtx(alias, ctxVar, (Resource)ctxValue);
        s.setTypes(this.tables.getSubjTypes(predId));
        o.setTypes(this.tables.getObjTypes(predId));
        SelectQuery query = new SelectQuery();
        query.setFrom(from);
        HashMap<String, ColumnVar> vars = new HashMap<String, ColumnVar>(4);
        for (ColumnVar var : new ColumnVar[]{s, p, o, c}) {
            from.addVar(var);
            Value value = var.getValue();
            if (vars.containsKey(var.getName())) {
                IdColumn existing = new IdColumn((ColumnVar)vars.get(var.getName()));
                from.addFilter(new SqlEq(new IdColumn(var), existing));
            } else if (value != null && !var.isImplied()) {
                try {
                    NumberValue vc = new NumberValue(this.vf.getInternalId(value));
                    from.addFilter(new SqlEq(new RefIdColumn(var), vc));
                }
                catch (RdbmsException e) {
                    throw new RdbmsRuntimeException(e);
                }
            } else {
                vars.put(var.getName(), var);
            }
            if (var.isHiddenOrConstant() || value != null) continue;
            SelectProjection proj = new SelectProjection();
            proj.setVar(var);
            proj.setId(new RefIdColumn(var));
            proj.setStringValue(SqlExprSupport.coalesce(new URIColumn(var), new BNodeColumn(var), new LabelColumn(var), new LongLabelColumn(var), new LongURIColumn(var)));
            proj.setDatatype(new DatatypeColumn(var));
            proj.setLanguage(new LanguageColumn(var));
            query.addSqlSelectVar(proj);
        }
        if (contexts.length > 0) {
            RdbmsResource[] ids = this.vf.asRdbmsResource(contexts);
            RefIdColumn var = new RefIdColumn(c);
            BinarySqlOperator in = null;
            for (RdbmsResource id : ids) {
                NumberValue longValue;
                try {
                    longValue = new NumberValue(this.vf.getInternalId(id));
                }
                catch (RdbmsException e) {
                    throw new RdbmsRuntimeException(e);
                }
                SqlEq eq = new SqlEq(var.clone(), longValue);
                in = in == null ? eq : new SqlOr(in, eq);
            }
            from.addFilter(in);
        }
        sp.replaceWith((QueryModelNode)query);
    }

    public void meet(Filter node) throws RuntimeException {
        super.meet(node);
        if (node.getArg() instanceof SelectQuery) {
            SelectQuery query = (SelectQuery)node.getArg();
            ValueExpr condition = null;
            for (ValueExpr expr : this.flatten(node.getCondition())) {
                try {
                    query.addFilter(this.sql.createBooleanExpr(expr));
                }
                catch (UnsupportedRdbmsOperatorException e) {
                    if (condition == null) {
                        condition = expr;
                        continue;
                    }
                    condition = new And(condition, expr);
                }
            }
            if (condition == null) {
                node.replaceWith((QueryModelNode)node.getArg());
            } else {
                node.setCondition(condition);
            }
        }
    }

    public void meet(Projection node) throws RuntimeException {
        super.meet(node);
        if (node.getArg() instanceof SelectQuery) {
            SelectQuery query = (SelectQuery)node.getArg();
            HashMap<String, String> bindingVars = new HashMap<String, String>();
            ArrayList<SelectProjection> selection = new ArrayList<SelectProjection>();
            ProjectionElemList list = node.getProjectionElemList();
            for (ProjectionElem e : list.getElements()) {
                String source = e.getSourceName();
                String target = e.getTargetName();
                bindingVars.put(target, source);
                SelectProjection s = query.getSelectProjection(source);
                if (s == null) continue;
                selection.add(s);
            }
            query.setBindingVars(bindingVars);
            query.setSqlSelectVar(selection);
            node.replaceWith((QueryModelNode)query);
        }
    }

    public void meet(Slice node) throws RuntimeException {
        super.meet(node);
        if (node.getArg() instanceof SelectQuery) {
            SelectQuery query = (SelectQuery)node.getArg();
            if (node.getOffset() > 0L) {
                query.setOffset(node.getOffset());
            }
            if (node.getLimit() >= 0L) {
                query.setLimit(node.getLimit());
            }
            node.replaceWith((QueryModelNode)query);
        }
    }

    public void meet(Order node) throws RuntimeException {
        super.meet(node);
        if (!(node.getArg() instanceof SelectQuery)) {
            return;
        }
        SelectQuery query = (SelectQuery)node.getArg();
        try {
            for (OrderElem e : node.getElements()) {
                ValueExpr expr = e.getExpr();
                boolean asc = e.isAscending();
                query.addOrder(this.sql.createBNodeExpr(expr), asc);
                query.addOrder(this.sql.createUriExpr(expr), asc);
                query.addOrder(this.sql.createNumericExpr(expr), asc);
                query.addOrder(this.sql.createDatatypeExpr(expr), asc);
                query.addOrder(this.sql.createTimeExpr(expr), asc);
                query.addOrder(this.sql.createLanguageExpr(expr), asc);
                query.addOrder(this.sql.createLabelExpr(expr), asc);
            }
            node.replaceWith((QueryModelNode)query);
        }
        catch (UnsupportedRdbmsOperatorException unsupportedRdbmsOperatorException) {
            // empty catch block
        }
    }

    private void filterOn(SelectQuery left, SelectQuery right) {
        Map<String, ColumnVar> lvars = left.getVarMap();
        Map<String, ColumnVar> rvars = right.getVarMap();
        HashSet<String> names = new HashSet<String>(rvars.keySet());
        names.retainAll(lvars.keySet());
        for (String name : names) {
            ColumnVar l = lvars.get(name);
            ColumnVar r = rvars.get(name);
            if (l.isImplied() || r.isImplied()) continue;
            IdColumn rid = new IdColumn(r);
            SqlExpr filter = SqlExprSupport.eq(rid, new IdColumn(l));
            if (r.isNullable()) {
                filter = SqlExprSupport.or(SqlExprSupport.isNull(rid), filter);
            }
            right.addFilter(filter);
        }
    }

    private Number getInternalId(Value predValue) {
        try {
            return this.vf.getInternalId(predValue);
        }
        catch (RdbmsException e) {
            throw new RdbmsRuntimeException(e);
        }
    }

    private Resource[] getContexts(StatementPattern sp, Value ctxValue) {
        Set<URI> graphs = this.getGraphs(sp);
        if (graphs == null) {
            if (ctxValue != null) {
                return new Resource[]{(Resource)ctxValue};
            }
            return new Resource[0];
        }
        if (graphs.isEmpty()) {
            return null;
        }
        if (ctxValue == null) {
            return graphs.toArray(new Resource[graphs.size()]);
        }
        if (graphs.contains(ctxValue)) {
            return new Resource[]{(Resource)ctxValue};
        }
        return null;
    }

    private Set<URI> getGraphs(StatementPattern sp) {
        if (this.dataset == null) {
            return null;
        }
        if (this.dataset.getDefaultGraphs().isEmpty() && this.dataset.getNamedGraphs().isEmpty()) {
            return null;
        }
        if (sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS) {
            return this.dataset.getDefaultGraphs();
        }
        return this.dataset.getNamedGraphs();
    }

    private String getTableAlias(Value predValue) {
        String alias;
        String localName;
        if (predValue != null && (localName = ((URI)predValue).getLocalName()).length() >= 1 && this.isLetters(alias = localName.substring(0, 1))) {
            return alias;
        }
        return ALIAS;
    }

    private Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    private boolean isLetters(String alias) {
        int n = alias.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(alias.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void mergeSelectClause(SelectQuery left, SelectQuery right) {
        for (SelectProjection proj : right.getSqlSelectVar()) {
            if (left.hasSqlSelectVar(proj)) continue;
            ColumnVar var = (proj = proj.clone()).getVar();
            String name = var.getName();
            ColumnVar existing = left.getVar(name);
            if (existing != null) {
                proj.setVar(existing);
            }
            left.addSqlSelectVar(proj);
        }
    }

    private List<ValueExpr> flatten(ValueExpr condition) {
        return this.flatten(condition, new ArrayList<ValueExpr>());
    }

    private List<ValueExpr> flatten(ValueExpr condition, List<ValueExpr> conditions) {
        if (condition instanceof And) {
            And and = (And)condition;
            this.flatten(and.getLeftArg(), conditions);
            this.flatten(and.getRightArg(), conditions);
        } else {
            conditions.add(condition);
        }
        return conditions;
    }
}

