/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class FloatCast
implements Function {
    public String getURI() {
        return XMLSchema.FLOAT.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:float cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String floatValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (XMLDatatypeUtil.isValidFloat((String)floatValue)) {
                    return valueFactory.createLiteral(floatValue, XMLSchema.FLOAT);
                }
            } else if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.FLOAT)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((URI)datatype)) {
                    try {
                        float floatValue = literal.floatValue();
                        return valueFactory.createLiteral(floatValue);
                    }
                    catch (NumberFormatException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
                if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? 1.0f : 0.0f);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:float cast: " + args[0]);
    }
}

