/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class Contains
implements Function {
    public String getURI() {
        return FN.CONTAINS.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("CONTAINS requires 2 arguments, got " + args.length);
        }
        Value leftVal = args[0];
        Value rightVal = args[1];
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            Literal leftLit = (Literal)leftVal;
            Literal rightLit = (Literal)rightVal;
            if (leftLit.getLanguage() != null) {
                if (rightLit.getLanguage() == null || rightLit.getLanguage().equals(leftLit.getLanguage())) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteralImpl.valueOf((boolean)leftLexVal.contains(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
            }
            if (QueryEvaluationUtil.isStringLiteral(leftLit)) {
                if (QueryEvaluationUtil.isStringLiteral(rightLit)) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteralImpl.valueOf((boolean)leftLexVal.contains(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
            }
            throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
        }
        throw new ValueExprEvaluationException("CONTAINS function expects literal operands");
    }
}

