/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class SameTermFilterOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new SameTermFilterVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class VarBinder
    extends QueryModelVisitorBase<RuntimeException> {
        private final String varName;
        private final Value value;

        public VarBinder(String varName, Value value) {
            this.varName = varName;
            this.value = value;
        }

        public void meet(Var var) {
            if (var.getName().equals(this.varName)) {
                var.setValue(this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class VarRenamer
    extends QueryModelVisitorBase<RuntimeException> {
        private final String oldName;
        private final String newName;

        public VarRenamer(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        public void meet(Var var) {
            if (var.getName().equals(this.oldName)) {
                var.setName(this.newName);
            }
        }

        public void meet(ProjectionElem projElem) throws RuntimeException {
            if (projElem.getSourceName().equals(this.oldName)) {
                projElem.setSourceName(this.newName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SameTermFilterVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected SameTermFilterVisitor() {
        }

        public void meet(Filter filter) {
            super.meet(filter);
            if (filter.getCondition() instanceof SameTerm) {
                SameTerm sameTerm = (SameTerm)filter.getCondition();
                TupleExpr filterArg = filter.getArg();
                ValueExpr leftArg = sameTerm.getLeftArg();
                ValueExpr rightArg = sameTerm.getRightArg();
                Set bindingNames = filterArg.getBindingNames();
                if (this.isUnboundVar(leftArg, bindingNames) || this.isUnboundVar(rightArg, bindingNames)) {
                    filter.replaceWith((QueryModelNode)new EmptySet());
                    return;
                }
                Set assuredBindingNames = filterArg.getAssuredBindingNames();
                if (this.isUnboundVar(leftArg, assuredBindingNames) || this.isUnboundVar(rightArg, assuredBindingNames)) {
                    return;
                }
                Value leftValue = this.getValue(leftArg);
                Value rightValue = this.getValue(rightArg);
                if (leftValue == null || rightValue == null) {
                    if (leftValue != null && rightArg instanceof Var) {
                        this.bindVar((Var)rightArg, leftValue, filter);
                    } else if (rightValue != null && leftArg instanceof Var) {
                        this.bindVar((Var)leftArg, rightValue, filter);
                    } else if (leftArg instanceof Var && rightArg instanceof Var) {
                        this.renameVar((Var)rightArg, (Var)leftArg, filter);
                    }
                }
            }
        }

        private boolean isUnboundVar(ValueExpr valueExpr, Set<String> bindingNames) {
            if (valueExpr instanceof Var) {
                Var var = (Var)valueExpr;
                return !var.hasValue() && !bindingNames.contains(var.getName());
            }
            return false;
        }

        private Value getValue(ValueExpr valueExpr) {
            if (valueExpr instanceof ValueConstant) {
                return ((ValueConstant)valueExpr).getValue();
            }
            if (valueExpr instanceof Var) {
                return ((Var)valueExpr).getValue();
            }
            return null;
        }

        private void renameVar(Var oldVar, Var newVar, Filter filter) {
            filter.getArg().visit((QueryModelVisitor)new VarRenamer(oldVar.getName(), newVar.getName()));
            Extension extension = new Extension(filter.getArg());
            extension.addElement(new ExtensionElem((ValueExpr)new Var(newVar.getName()), oldVar.getName()));
            filter.replaceWith((QueryModelNode)extension);
        }

        private void bindVar(Var var, Value value, Filter filter) {
            filter.getArg().visit((QueryModelVisitor)new VarBinder(var.getName(), value));
        }
    }
}

