/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLParser;
import org.openrdf.repository.sparql.query.BackgroundTupleResult;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;
import org.openrdf.repository.sparql.query.SPARQLQuery;

public class SPARQLTupleQuery
extends SPARQLQuery
implements TupleQuery {
    private SPARQLResultsXMLParser parser = new SPARQLResultsXMLParser();

    public SPARQLTupleQuery(HttpClient client, String url, String base, String query) {
        super(client, url, base, query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        try {
            BackgroundTupleResult result = null;
            HttpMethodBase response = this.getResponse();
            try {
                InputStream in = response.getResponseBodyAsStream();
                result = new BackgroundTupleResult((TupleQueryResultParser)this.parser, in, (HttpMethod)response);
                this.execute(result);
                InsertBindingSetCursor cursor = new InsertBindingSetCursor((CloseableIteration<BindingSet, QueryEvaluationException>)result, this.getBindings());
                ArrayList<String> list = new ArrayList<String>(result.getBindingNames());
                list.addAll(this.getBindingNames());
                TupleQueryResultImpl tupleQueryResultImpl = new TupleQueryResultImpl(list, (CloseableIteration)cursor);
                return tupleQueryResultImpl;
            }
            catch (HttpException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                if (result == null) {
                    response.abort();
                }
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        try {
            boolean complete = false;
            HttpMethodBase response = this.getResponse();
            try {
                this.parser.setTupleQueryResultHandler(handler);
                this.parser.parse(response.getResponseBodyAsStream());
                complete = true;
            }
            catch (HttpException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (QueryResultParseException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (TupleQueryResultHandlerException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                if (!complete) {
                    response.abort();
                }
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    protected String getAccept() {
        return this.parser.getTupleQueryResultFormat().getDefaultMIMEType();
    }
}

