/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.archetype.ui.generation.ArchetypeSelector;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class CreateProjectFromArchetypeMojo
extends AbstractMojo
implements ContextEnabled {
    private ArchetypeManager manager;
    private ArchetypeSelector selector;
    private ArchetypeGenerationConfigurator configurator;
    private Invoker invoker;
    private String archetypeArtifactId;
    private String archetypeGroupId;
    private String archetypeVersion;
    private String archetypeRepository;
    private String archetypeCatalog;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private Boolean interactiveMode;
    private File basedir;
    private MavenSession session;
    private String goals;
    private String filter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties executionProperties = this.session.getExecutionProperties();
        ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setArchetypeGroupId(this.archetypeGroupId).setArchetypeArtifactId(this.archetypeArtifactId).setArchetypeVersion(this.archetypeVersion).setOutputDirectory(this.basedir.getAbsolutePath()).setLocalRepository(this.localRepository).setArchetypeRepository(this.archetypeRepository).setRemoteArtifactRepositories(this.remoteArtifactRepositories).setFilter(this.filter);
        try {
            if (this.interactiveMode.booleanValue()) {
                this.getLog().info((CharSequence)"Generating project in Interactive mode");
            } else {
                this.getLog().info((CharSequence)"Generating project in Batch mode");
            }
            this.selector.selectArchetype(request, this.interactiveMode, this.archetypeCatalog);
            if (StringUtils.isBlank((String)request.getArchetypeArtifactId())) {
                return;
            }
            this.configurator.configureArchetype(request, this.interactiveMode, executionProperties);
            ArchetypeGenerationResult generationResult = this.manager.generateProjectFromArchetype(request);
            if (generationResult.getCause() != null) {
                throw new MojoFailureException((Object)generationResult.getCause(), generationResult.getCause().getMessage(), generationResult.getCause().getMessage());
            }
        }
        catch (MojoFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (MojoFailureException)new MojoFailureException(ex.getMessage()).initCause((Throwable)ex);
        }
        String artifactId = request.getArtifactId();
        String postArchetypeGenerationGoals = request.getArchetypeGoals();
        if (StringUtils.isEmpty((String)postArchetypeGenerationGoals)) {
            postArchetypeGenerationGoals = this.goals;
        }
        if (StringUtils.isNotEmpty((String)postArchetypeGenerationGoals)) {
            this.invokePostArchetypeGenerationGoals(postArchetypeGenerationGoals, artifactId);
        }
    }

    private void invokePostArchetypeGenerationGoals(String goals, String artifactId) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Invoking post-archetype-generation goals: " + goals));
        File projectBasedir = new File(this.basedir, artifactId);
        if (projectBasedir.exists()) {
            InvocationRequest request = new DefaultInvocationRequest().setBaseDirectory(projectBasedir).setGoals(Arrays.asList(StringUtils.split((String)goals, (String)",")));
            try {
                this.invoker.execute(request);
            }
            catch (MavenInvocationException e) {
                throw new MojoExecutionException("Cannot run additions goals.", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)("Post-archetype-generation goals aborted: unavailable basedir " + projectBasedir));
        }
    }
}

