/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.creation;

import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationQueryer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArchetypeCreationQueryer.class)
public class DefaultArchetypeCreationQueryer
extends AbstractLogEnabled
implements ArchetypeCreationQueryer {
    @Requirement
    private Prompter prompter;

    public String getArchetypeArtifactId(String defaultValue) throws PrompterException {
        return this.getValue("archetype.artifactId", defaultValue);
    }

    public String getArchetypeGroupId(String defaultValue) throws PrompterException {
        return this.getValue("archetype.groupId", defaultValue);
    }

    public String getArchetypeVersion(String defaultValue) throws PrompterException {
        return this.getValue("archetype.version", defaultValue);
    }

    public String getArtifactId(String defaultValue) throws PrompterException {
        return this.getValue("artifactId", defaultValue);
    }

    public boolean askAddAnotherProperty() throws PrompterException {
        String query = "Add a new custom property";
        String answer = this.prompter.prompt(query, "Y");
        return "Y".equalsIgnoreCase(answer);
    }

    public String askNewPropertyKey() throws PrompterException {
        String query = "Define property key";
        String answer = this.prompter.prompt(query);
        return answer;
    }

    public String askReplacementValue(String propertyKey, String defaultValue) throws PrompterException {
        return this.getValue(propertyKey, defaultValue);
    }

    public boolean confirmConfiguration(ArchetypeConfiguration archetypeConfiguration) throws PrompterException {
        StringBuilder query = new StringBuilder("Confirm archetype configuration:\narchetype.groupId=" + archetypeConfiguration.getGroupId() + "\n" + "archetype.artifactId" + "=" + archetypeConfiguration.getArtifactId() + "\n" + "archetype.version" + "=" + archetypeConfiguration.getVersion() + "\n");
        for (String string : archetypeConfiguration.getProperties().keySet()) {
            query.append(string + "=" + archetypeConfiguration.getProperty(string) + "\n");
        }
        String answer = this.prompter.prompt(query.toString(), "Y");
        return "Y".equalsIgnoreCase(answer);
    }

    public String getGroupId(String defaultValue) throws PrompterException {
        return this.getValue("groupId", defaultValue);
    }

    public String getPackage(String defaultValue) throws PrompterException {
        return this.getValue("package", defaultValue);
    }

    public String getVersion(String defaultValue) throws PrompterException {
        return this.getValue("version", defaultValue);
    }

    private String getValue(String requiredProperty, String defaultValue) throws PrompterException {
        String query = "Define value for " + requiredProperty + ": ";
        String answer = defaultValue != null && !defaultValue.equals("null") ? this.prompter.prompt(query, defaultValue) : this.prompter.prompt(query);
        return answer;
    }
}

