/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.ArchetypeSelectionFailure;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.exception.UnknownGroup;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectionQueryer;
import org.apache.maven.archetype.ui.generation.ArchetypeSelector;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeSelector.class)
public class DefaultArchetypeSelector
extends AbstractLogEnabled
implements ArchetypeSelector {
    static final String DEFAULT_ARCHETYPE_GROUPID = "org.apache.maven.archetypes";
    static final String DEFAULT_ARCHETYPE_VERSION = "1.0";
    static final String DEFAULT_ARCHETYPE_ARTIFACTID = "maven-archetype-quickstart";
    @Requirement
    private ArchetypeSelectionQueryer archetypeSelectionQueryer;
    @Requirement
    private ArchetypeManager archetypeManager;

    @Override
    public void selectArchetype(ArchetypeGenerationRequest request, Boolean interactiveMode, String catalogs) throws ArchetypeNotDefined, UnknownArchetype, UnknownGroup, IOException, PrompterException, ArchetypeSelectionFailure {
        Archetype archetype;
        String catalogKey;
        Map.Entry<String, Archetype> found;
        ArchetypeDefinition definition = new ArchetypeDefinition(request);
        if (definition.isDefined() && StringUtils.isNotEmpty((String)request.getArchetypeRepository())) {
            this.getLogger().info("Archetype defined by properties");
            return;
        }
        Map<String, List<Archetype>> archetypes = this.getArchetypesByCatalog(catalogs);
        if (StringUtils.isNotBlank((String)request.getFilter()) && (archetypes = ArchetypeSelectorUtils.getFilteredArchetypesByCatalog(archetypes, request.getFilter())).isEmpty()) {
            this.getLogger().info("Your filter doesn't match any archetype, so try again with another value.");
            return;
        }
        if (definition.isDefined() && StringUtils.isEmpty((String)request.getArchetypeRepository())) {
            found = this.findArchetype(archetypes, request.getArchetypeGroupId(), request.getArchetypeArtifactId());
            if (found != null) {
                catalogKey = found.getKey();
                archetype = found.getValue();
                this.updateRepository(definition, archetype, catalogKey);
                this.getLogger().info("Archetype repository missing. Using the one from " + archetype + " found in catalog " + catalogKey);
            } else {
                this.getLogger().warn("Archetype not found in any catalog. Falling back to central repository (http://repo1.maven.org/maven2).");
                this.getLogger().warn("Use -DarchetypeRepository=<your repository> if archetype's repository is elsewhere.");
                definition.setRepository("http://repo1.maven.org/maven2");
            }
        }
        if (!definition.isDefined() && definition.isPartiallyDefined()) {
            found = this.findArchetype(archetypes, request.getArchetypeGroupId(), request.getArchetypeArtifactId());
            if (found != null) {
                catalogKey = found.getKey();
                archetype = found.getValue();
                this.updateDefinition(definition, archetype, catalogKey);
                this.getLogger().info("Archetype " + archetype + " found in catalog " + catalogKey);
            } else {
                this.getLogger().warn("Specified archetype not found.");
                if (interactiveMode.booleanValue()) {
                    definition.setVersion(null);
                    definition.setGroupId(null);
                    definition.setArtifactId(null);
                }
            }
        }
        if (definition.getGroupId() == null) {
            definition.setGroupId(DEFAULT_ARCHETYPE_GROUPID);
        }
        if (definition.getVersion() == null) {
            definition.setVersion(DEFAULT_ARCHETYPE_VERSION);
        }
        if (!definition.isPartiallyDefined()) {
            if (definition.getArtifactId() == null) {
                this.getLogger().info("No archetype defined. Using maven-archetype-quickstart (" + definition.getGroupId() + ":" + DEFAULT_ARCHETYPE_ARTIFACTID + ":" + definition.getVersion() + ")");
                definition.setArtifactId(DEFAULT_ARCHETYPE_ARTIFACTID);
            }
            if (interactiveMode.booleanValue() && archetypes.size() > 0) {
                Archetype selectedArchetype = this.archetypeSelectionQueryer.selectArchetype(archetypes, definition);
                catalogKey = this.getCatalogKey(archetypes, selectedArchetype);
                this.updateDefinition(definition, selectedArchetype, catalogKey);
            }
            if (!definition.isPartiallyDefined()) {
                throw new ArchetypeSelectionFailure("No valid archetypes could be found to choose.");
            }
        }
        definition.updateRequest(request);
    }

    private Map<String, List<Archetype>> getArchetypesByCatalog(String catalogs) {
        if (catalogs == null) {
            throw new NullPointerException("catalogs cannot be null");
        }
        LinkedHashMap<String, List<Archetype>> archetypes = new LinkedHashMap<String, List<Archetype>>();
        for (String catalog : StringUtils.split((String)catalogs, (String)",")) {
            if ("internal".equalsIgnoreCase(catalog)) {
                archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
                continue;
            }
            if ("local".equalsIgnoreCase(catalog)) {
                archetypes.put("local", this.archetypeManager.getDefaultLocalCatalog().getArchetypes());
                continue;
            }
            if ("remote".equalsIgnoreCase(catalog)) {
                List archetypesFromRemote = this.archetypeManager.getRemoteCatalog().getArchetypes();
                if (archetypesFromRemote.size() > 0) {
                    archetypes.put("remote", archetypesFromRemote);
                    continue;
                }
                this.getLogger().warn("No archetype found in remote catalog. Defaulting to internal catalog");
                archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
                continue;
            }
            if (catalog.startsWith("file://")) {
                String path = catalog.substring(7);
                archetypes.put(catalog, this.archetypeManager.getLocalCatalog(path).getArchetypes());
                continue;
            }
            if (!catalog.startsWith("http://") && !catalog.startsWith("https://")) continue;
            archetypes.put(catalog, this.archetypeManager.getRemoteCatalog(catalog).getArchetypes());
        }
        if (archetypes.size() == 0) {
            this.getLogger().info("No catalog defined. Using internal catalog");
            archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
        }
        return archetypes;
    }

    private void updateRepository(ArchetypeDefinition definition, Archetype archetype, String catalogKey) {
        String repository = archetype.getRepository();
        if (StringUtils.isNotEmpty((String)repository)) {
            definition.setRepository(repository);
        } else if (catalogKey.indexOf(58) > 1) {
            int lastIndex = catalogKey.lastIndexOf(47);
            String catalogBase = catalogKey.substring(0, lastIndex > 7 ? lastIndex : catalogKey.length());
            definition.setRepository(catalogBase);
        }
    }

    private void updateDefinition(ArchetypeDefinition definition, Archetype archetype, String catalogKey) {
        definition.setGroupId(archetype.getGroupId());
        definition.setArtifactId(archetype.getArtifactId());
        definition.setVersion(archetype.getVersion());
        definition.setName(archetype.getArtifactId());
        this.updateRepository(definition, archetype, catalogKey);
        definition.setGoals(StringUtils.join(archetype.getGoals().iterator(), (String)","));
    }

    public void setArchetypeSelectionQueryer(ArchetypeSelectionQueryer archetypeSelectionQueryer) {
        this.archetypeSelectionQueryer = archetypeSelectionQueryer;
    }

    private String getCatalogKey(Map<String, List<Archetype>> archetypes, Archetype selectedArchetype) {
        for (Map.Entry<String, List<Archetype>> entry : archetypes.entrySet()) {
            List<Archetype> catalog = entry.getValue();
            if (!catalog.contains(selectedArchetype)) continue;
            return entry.getKey();
        }
        return "";
    }

    private Map.Entry<String, Archetype> findArchetype(Map<String, List<Archetype>> archetypes, String groupId, String artifactId) {
        Archetype example = new Archetype();
        example.setGroupId(groupId);
        example.setArtifactId(artifactId);
        for (Map.Entry<String, List<Archetype>> entry : archetypes.entrySet()) {
            List<Archetype> catalog = entry.getValue();
            if (!catalog.contains(example)) continue;
            Archetype archetype = catalog.get(catalog.indexOf(example));
            return DefaultArchetypeSelector.newMapEntry(entry.getKey(), archetype);
        }
        return null;
    }

    private static <K, V> Map.Entry<K, V> newMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map.entrySet().iterator().next();
    }
}

