/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockNone;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import virtuoso.jdbc4.VirtuosoDataSource;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtResSetQIter;

public class VirtDataSetGraph
implements DatasetGraph {
    private final Lock lock = new LockNone();
    private Context context = new Context();
    VirtGraph vg = null;

    public VirtDataSetGraph(VirtGraph virtGraph) {
        this.vg = virtGraph;
    }

    public VirtDataSetGraph(String string, VirtuosoDataSource virtuosoDataSource) {
        this.vg = new VirtGraph(string, virtuosoDataSource);
    }

    public VirtDataSetGraph(String string, String string2, String string3) {
        this.vg = new VirtGraph(string, string2, string3);
    }

    public Graph getDefaultGraph() {
        return this.vg;
    }

    public Graph getGraph(Node node) {
        try {
            return new VirtGraph(node.toString(), this.vg.getGraphUrl(), this.vg.getGraphUser(), this.vg.getGraphPassword());
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public boolean containsGraph(Node node) {
        String string = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            PreparedStatement preparedStatement = this.vg.prepareStatement(string);
            preparedStatement.setString(1, node.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return n != 0;
    }

    public void setDefaultGraph(Graph graph) {
    }

    public void addGraph(Node node, Graph graph) {
        boolean bl = false;
        try {
            bl = this.vg.getConnection().getAutoCommit();
            if (bl) {
                this.vg.getConnection().setAutoCommit(false);
            }
            this.vg.clearGraph(node.toString());
            ExtendedIterator extendedIterator = graph.find(Node.ANY, Node.ANY, Node.ANY);
            this.vg.add(node.toString(), (Iterator<Triple>)extendedIterator, null);
            this.vg.getConnection().commit();
        }
        catch (Exception exception) {
            try {
                this.vg.getConnection().rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new JenaException("Error in addGraph:" + exception);
        }
        finally {
            if (bl) {
                try {
                    this.vg.getConnection().setAutoCommit(true);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void removeGraph(Node node) {
        boolean bl = false;
        try {
            bl = this.vg.getConnection().getAutoCommit();
            if (bl) {
                this.vg.getConnection().setAutoCommit(false);
            }
            this.vg.clearGraph(node.toString());
            this.vg.getConnection().commit();
        }
        catch (Exception exception) {
            try {
                this.vg.getConnection().rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new JenaException("Error in removeGraph:" + exception);
        }
        finally {
            if (bl) {
                try {
                    this.vg.getConnection().setAutoCommit(true);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean isWildcard(Node node) {
        return node == null || Node.ANY.equals((Object)node);
    }

    protected List<Node> getListGraphNodes() {
        String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        ResultSet resultSet = null;
        boolean bl = false;
        this.checkOpen();
        try {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            Statement statement = this.vg.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                linkedList.add(Node.createURI((String)resultSet.getString(1)));
            }
            resultSet.close();
            return linkedList;
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public Iterator<Node> listGraphNodes() {
        return this.getListGraphNodes().iterator();
    }

    public void add(Quad quad) {
        this.vg.performAdd(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void delete(Quad quad) {
        this.vg.performDelete(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void add(Node node, Node node2, Node node3, Node node4) {
        this.vg.performAdd(node.toString(), node2, node3, node4);
    }

    public void delete(Node node, Node node2, Node node3, Node node4) {
        this.vg.performDelete(node.toString(), node2, node3, node4);
    }

    public void deleteAny(Node node, Node node2, Node node3, Node node4) {
        Triple triple = new Triple(node2, node3, node4);
        if (Node.ANY.equals((Object)node)) {
            String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
            ResultSet resultSet = null;
            Statement statement = null;
            this.checkOpen();
            try {
                statement = this.vg.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    this.vg.delete_match(resultSet.getString(1), (TripleMatch)triple);
                }
            }
            catch (Exception exception) {
                throw new JenaException("Error in deleteAny():" + exception);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.vg.delete_match(node.toString(), (TripleMatch)triple);
    }

    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Iterator<Quad> find(Quad quad) {
        if (quad == null) {
            return this.find();
        }
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public Iterator<Quad> find(Node node, Node node2, Node node3, Node node4) {
        List<Node> list;
        if (this.isWildcard(node)) {
            list = this.getListGraphNodes();
        } else {
            list = new LinkedList<Node>();
            list.add(node);
        }
        return new VirtResSetQIter(this.vg, list.iterator(), (TripleMatch)new Triple(node2, node3, node4));
    }

    public Iterator<Quad> findNG(Node node, Node node2, Node node3, Node node4) {
        return this.find(node, node2, node3, node4);
    }

    public boolean contains(Node node, Node node2, Node node3, Node node4) {
        if (this.isWildcard(node)) {
            boolean bl = this.vg.getReadFromAllGraphs();
            this.vg.setReadFromAllGraphs(true);
            boolean bl2 = this.vg.graphBaseContains(null, new Triple(node2, node3, node4));
            this.vg.setReadFromAllGraphs(bl);
            return bl2;
        }
        return this.vg.graphBaseContains(node.toString(), new Triple(node2, node3, node4));
    }

    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean isEmpty() {
        return !this.contains(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Lock getLock() {
        return this.lock;
    }

    public Context getContext() {
        return this.context;
    }

    public long size() {
        return this.vg.size();
    }

    public void close() {
        this.vg.close();
    }

    protected void checkOpen() {
        if (this.vg.isClosed()) {
            throw new ClosedException("already closed", (Graph)this.vg);
        }
    }
}

