/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.trig;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.rio.turtle.TurtleUtil;

public class TriGParser
extends TurtleParser {
    private Resource context;

    public TriGParser() {
    }

    public TriGParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIG;
    }

    protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peek();
        if (c == 64) {
            this.parseDirective();
            this.skipWSC();
            this.verifyCharacter(this.read(), ".");
        } else {
            this.parseGraph();
        }
    }

    protected void parseGraph() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.read();
        int c2 = this.peek();
        if (c == 60 || TurtleUtil.isPrefixStartChar((int)c) || c == 58 && c2 != 45 || c == 95 && c2 == 58) {
            this.unread(c);
            Value value = this.parseValue();
            if (value instanceof Resource) {
                this.context = (Resource)value;
            } else {
                this.reportFatalError("Illegal graph name: " + value);
            }
            this.skipWSC();
            c = this.read();
        } else {
            this.context = null;
        }
        if (c == 58) {
            this.verifyCharacter(this.read(), "-");
            this.skipWSC();
            c = this.read();
        }
        this.verifyCharacter(c, "{");
        c = this.skipWSC();
        if (c != 125) {
            this.parseTriples();
            c = this.skipWSC();
            while (c == 46) {
                this.read();
                c = this.skipWSC();
                if (c == 125) break;
                this.parseTriples();
                c = this.skipWSC();
            }
            this.verifyCharacter(c, "}");
        }
        this.read();
    }

    protected void reportStatement(Resource subj, URI pred, Value obj) throws RDFParseException, RDFHandlerException {
        Statement st = this.createStatement(subj, pred, obj, this.context);
        this.rdfHandler.handleStatement(st);
    }
}

