/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.util.Iterator;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.AbstractQuery;
import org.openrdf.repository.http.HTTPRepositoryConnection;

public abstract class HTTPQuery
extends AbstractQuery {
    protected final HTTPRepositoryConnection httpCon;
    protected final QueryLanguage queryLanguage;
    protected final String queryString;
    protected final String baseURI;

    public HTTPQuery(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        this.httpCon = con;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
    }

    protected Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        super.setMaxQueryTime(maxQueryTime);
        this.httpCon.getRepository().getHTTPClient().setConnectionTimeout(1000L * (long)this.maxQueryTime);
    }

    public String toString() {
        return this.queryString;
    }
}

