/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

public abstract class PropertySerializerMap {
    public abstract JsonSerializer<Object> serializerFor(Class<?> var1);

    @Deprecated
    public final SerializerAndMapResult findAndAddSerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        return this.findAndAddSecondarySerializer(clazz, serializerProvider, beanProperty);
    }

    @Deprecated
    public final SerializerAndMapResult findAndAddSerializer(JavaType javaType, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        return this.findAndAddSecondarySerializer(javaType, serializerProvider, beanProperty);
    }

    public final SerializerAndMapResult findAndAddPrimarySerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddPrimarySerializer(JavaType javaType, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(clazz, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(JavaType javaType, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(javaType, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public abstract PropertySerializerMap newWith(Class<?> var1, JsonSerializer<Object> var2);

    public static PropertySerializerMap emptyMap() {
        return Empty.instance;
    }

    private static final class Multi
    extends PropertySerializerMap {
        private static final int MAX_ENTRIES = 8;
        private final TypeAndSerializer[] _entries;

        public Multi(TypeAndSerializer[] typeAndSerializerArray) {
            this._entries = typeAndSerializerArray;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            for (TypeAndSerializer typeAndSerializer : this._entries) {
                if (typeAndSerializer.type != clazz) continue;
                return typeAndSerializer.serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            int n = this._entries.length;
            if (n == 8) {
                return this;
            }
            TypeAndSerializer[] typeAndSerializerArray = new TypeAndSerializer[n + 1];
            System.arraycopy(this._entries, 0, typeAndSerializerArray, 0, n);
            typeAndSerializerArray[n] = new TypeAndSerializer(clazz, jsonSerializer);
            return new Multi(typeAndSerializerArray);
        }
    }

    private static final class Double
    extends PropertySerializerMap {
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final JsonSerializer<Object> _serializer1;
        private final JsonSerializer<Object> _serializer2;

        public Double(Class<?> clazz, JsonSerializer<Object> jsonSerializer, Class<?> clazz2, JsonSerializer<Object> jsonSerializer2) {
            this._type1 = clazz;
            this._serializer1 = jsonSerializer;
            this._type2 = clazz2;
            this._serializer2 = jsonSerializer2;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            if (clazz == this._type1) {
                return this._serializer1;
            }
            if (clazz == this._type2) {
                return this._serializer2;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            TypeAndSerializer[] typeAndSerializerArray = new TypeAndSerializer[]{new TypeAndSerializer(this._type1, this._serializer1), new TypeAndSerializer(this._type2, this._serializer2)};
            return new Multi(typeAndSerializerArray);
        }
    }

    private static final class Single
    extends PropertySerializerMap {
        private final Class<?> _type;
        private final JsonSerializer<Object> _serializer;

        public Single(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            this._type = clazz;
            this._serializer = jsonSerializer;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            if (clazz == this._type) {
                return this._serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            return new Double(this._type, this._serializer, clazz, jsonSerializer);
        }
    }

    private static final class Empty
    extends PropertySerializerMap {
        protected static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            return new Single(clazz, jsonSerializer);
        }
    }

    private static final class TypeAndSerializer {
        public final Class<?> type;
        public final JsonSerializer<Object> serializer;

        public TypeAndSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            this.type = clazz;
            this.serializer = jsonSerializer;
        }
    }

    public static final class SerializerAndMapResult {
        public final JsonSerializer<Object> serializer;
        public final PropertySerializerMap map;

        public SerializerAndMapResult(JsonSerializer<Object> jsonSerializer, PropertySerializerMap propertySerializerMap) {
            this.serializer = jsonSerializer;
            this.map = propertySerializerMap;
        }
    }
}

