/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.ModQueryIn;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.util.PrintSDB;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.OutputStream;
import java.util.List;
import sdb.cmd.CmdArgsDB;

public class sdbprint
extends CmdArgsDB {
    LayoutType layoutDefault = LayoutType.LayoutTripleNodesHash;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    ModQueryIn modQuery = new ModQueryIn(Syntax.syntaxARQ);
    ArgDecl argDeclPrintSQL = new ArgDecl(false, "sql", new String[0]);
    ArgDecl argDeclPrint = new ArgDecl(true, "print", new String[0]);
    boolean printQuery = false;
    boolean printOp = false;
    boolean printSqlNode = false;
    boolean printPlan = false;
    boolean printSQL = false;
    boolean needDivider = false;

    public static void main(String ... argv) {
        SDB.init();
        new sdbprint(argv).mainRun();
    }

    public sdbprint(String ... args) {
        super(args);
        super.addModule((ArgModuleGeneral)this.modQuery);
        super.getUsage().startCategory("SQL");
        super.add(this.argDeclPrintSQL, "--sql", "Print SQL");
        super.add(this.argDeclPrint, "--print=", "Print any of 'query', 'op', 'sqlnode', 'SQL', 'plan'");
    }

    protected void processModulesAndArgs() {
        StoreDesc storeDesc = this.getModStore().getStoreDesc();
        storeDesc.connDesc.setJdbcURL("jdbc:none");
        if (storeDesc.getLayout() == null) {
            storeDesc.setLayout(this.layoutDefault);
        }
        this.printSQL = this.contains(this.argDeclPrintSQL);
        List strList = this.getValues(this.argDeclPrint);
        for (String arg : strList) {
            if (arg.equalsIgnoreCase("query")) {
                this.printQuery = true;
                continue;
            }
            if (arg.equalsIgnoreCase("Op")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("SqlNode")) {
                this.printSqlNode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("sql")) {
                this.printSQL = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, prefix, op, sqlNode, sql");
        }
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        Query query2 = this.modQuery.getQuery();
        this.compilePrint(this.getStore(), query2);
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    private void compilePrint(Store store, Query query2) {
        SDB.getContext().setIfUndef(SDB.annotateGeneratedSQL, (Object)true);
        if (!(this.printQuery || this.printOp || this.printSqlNode || this.printSQL || this.printPlan)) {
            this.printSQL = true;
        }
        if (this.isVerbose()) {
            this.printOp = true;
            this.printSQL = true;
        }
        if (this.printQuery) {
            this.divider();
            query2.serialize((OutputStream)System.out, Syntax.syntaxARQ);
        }
        QueryEngineSDB qe = new QueryEngineSDB(store, query2);
        Op op = qe.getOp();
        if (this.printOp) {
            this.divider();
            PrintSDB.print(op);
        }
        if (this.printSqlNode) {
            this.divider();
            PrintSDB.printSqlNodes(op);
        }
        if (this.printSQL) {
            this.divider();
            PrintSDB.printSQL(op);
        }
        if (this.printPlan) {
            this.divider();
            System.out.print(qe.getPlan());
        }
    }

    protected String getSummary() {
        return "Usage: [--layout schemaName] [--query URL | string ] ";
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

