/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader2;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.Build;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.atlas.logging.ProgressLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdb.cmdline.CmdTDB;

public class CmdIndexCopy {
    private static Logger log;
    static long tickQuantum;
    static int superTick;

    public static void main(String ... argv) {
        CmdTDB.init();
        if (argv.length != 4) {
            System.err.println("Usage: Location1 Index1 Location2 Index2");
            System.exit(1);
        }
        String locationStr1 = argv[0];
        String indexName1 = argv[1];
        String locationStr2 = argv[2];
        String indexName2 = argv[3];
        Location location1 = new Location(locationStr1);
        Location location2 = new Location(locationStr2);
        int keyLength = 8 * indexName1.length();
        int valueLength = 0;
        String primary = "SPO";
        String indexOrder = indexName2;
        String label = indexName1 + " => " + indexName2;
        TupleIndex index1 = Build.openTupleIndex(location1, indexName1, primary, indexName1, 10, 10, keyLength, valueLength);
        TupleIndex index2 = Build.openTupleIndex(location2, indexName2, primary, indexOrder, 10, 10, keyLength, valueLength);
        CmdIndexCopy.tupleIndexCopy(index1, index2, label);
        index1.close();
        index2.close();
    }

    private static void tupleIndexCopy(TupleIndex index1, TupleIndex index2, String label) {
        ProgressLogger monitor = new ProgressLogger(log, label, tickQuantum, superTick);
        monitor.start();
        Iterator<Tuple<NodeId>> iter1 = index1.all();
        long counter = 0L;
        while (iter1.hasNext()) {
            ++counter;
            Tuple<NodeId> tuple = iter1.next();
            index2.add(tuple);
            monitor.tick();
        }
        index2.sync();
        long time = monitor.finish();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)counter / elapsedSecs : 0.0f;
        CmdIndexCopy.print("Total: %,d records : %,.2f seconds : %,.2f records/sec [%s]", counter, Float.valueOf(elapsedSecs), Float.valueOf(rate), Utils.nowAsString());
    }

    private static void print(String fmt, Object ... args) {
        if (log != null && log.isInfoEnabled()) {
            String str = String.format(fmt, args);
            log.info(str);
        }
    }

    static {
        LogCtl.setLog4j();
        log = LoggerFactory.getLogger(CmdIndexCopy.class);
        tickQuantum = 100000L;
        superTick = 10;
    }
}

