/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndexRecord;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.apache.jena.atlas.lib.ColumnMap;
import org.slf4j.Logger;

public class SetupTDB {
    static final Logger log = TDB.logInfo;
    private static StoreParams params = StoreParams.getDftStoreParams();

    public static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    public static TupleIndex[] makeTupleIndexes(Location location, String primary, String[] descs, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            SetupTDB.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[descs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = SetupTDB.makeTupleIndex(location, primary, descs[i], filenames[i], indexRecordLen);
        }
        return indexes;
    }

    public static TupleIndex makeTupleIndex(Location location, String primary, String indexOrder, String indexName, int keyLength) {
        FileSet fs = new FileSet(location, indexName);
        int readCacheSize = params.getBlockReadCacheSize();
        int writeCacheSize = params.getBlockWriteCacheSize();
        RangeIndex rIndex = SetupTDB.makeRangeIndex(location, indexName, params.getBlockSize(), keyLength, 0, readCacheSize, writeCacheSize);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), indexOrder, rIndex.getRecordFactory(), rIndex);
        return tupleIndex;
    }

    public static Index makeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupTDB.makeRangeIndex(location, indexName, blkSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeRangeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        FileSet fs = new FileSet(location, indexName);
        RangeIndex rIndex = SetupTDB.makeBPlusTree(fs, blkSize, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
        return rIndex;
    }

    public static RangeIndex makeBPlusTree(FileSet fs, int blkSize, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        RecordFactory recordFactory = SetupTDB.makeRecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        BPlusTree rIndex = SetupTDB.createBPTree(fs, order, blkSize, readCacheSize, writeCacheSize, recordFactory);
        return rIndex;
    }

    public static RecordFactory makeRecordFactory(int keyLen, int valueLen) {
        return new RecordFactory(keyLen, valueLen);
    }

    public static ObjectFile makeObjectFile(FileSet fsIdToNode) {
        String filename = fsIdToNode.filename("dat");
        ObjectFile objFile = FileFactory.createObjectFileDisk(filename);
        return objFile;
    }

    public static RangeIndex createBPTree(FileSet fileset, RecordFactory factory) {
        int readCacheSize = SystemTDB.BlockReadCacheSize;
        int writeCacheSize = SystemTDB.BlockWriteCacheSize;
        int blockSize = 8192;
        if (fileset.isMem()) {
            readCacheSize = 0;
            writeCacheSize = 0;
            blockSize = 1024;
        }
        return SetupTDB.createBPTreeByBlockSize(fileset, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByBlockSize(FileSet fileset, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupTDB.createBPTree(fileset, -1, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByOrder(FileSet fileset, int order, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupTDB.createBPTree(fileset, order, -1, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        int order2;
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        if (blockSize < 0 && order >= 0) {
            blockSize = BPlusTreeParams.calcBlockSize(order, factory);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(fileset, "idn", blockSize, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(fileset, "dat", blockSize, readCacheSize, writeCacheSize);
        return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
    }
}

