/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class RDFHandlerWrapper
implements RDFHandler {
    private final RDFHandler[] rdfHandlers;

    public RDFHandlerWrapper(RDFHandler ... rdfHandlers) {
        assert (rdfHandlers != null);
        this.rdfHandlers = rdfHandlers;
    }

    public void startRDF() throws RDFHandlerException {
        RDFHandler[] rDFHandlerArray = this.rdfHandlers;
        int n = this.rdfHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RDFHandler rdfHandler = rDFHandlerArray[n2];
            rdfHandler.startRDF();
            ++n2;
        }
    }

    public void endRDF() throws RDFHandlerException {
        RDFHandler[] rDFHandlerArray = this.rdfHandlers;
        int n = this.rdfHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RDFHandler rdfHandler = rDFHandlerArray[n2];
            rdfHandler.endRDF();
            ++n2;
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        RDFHandler[] rDFHandlerArray = this.rdfHandlers;
        int n = this.rdfHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RDFHandler rdfHandler = rDFHandlerArray[n2];
            rdfHandler.handleNamespace(prefix, uri);
            ++n2;
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        RDFHandler[] rDFHandlerArray = this.rdfHandlers;
        int n = this.rdfHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RDFHandler rdfHandler = rDFHandlerArray[n2];
            rdfHandler.handleStatement(st);
            ++n2;
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        RDFHandler[] rDFHandlerArray = this.rdfHandlers;
        int n = this.rdfHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RDFHandler rdfHandler = rDFHandlerArray[n2];
            rdfHandler.handleComment(comment);
            ++n2;
        }
    }
}

