/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sdb.layout1.EncoderDecoder;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.FmtUtils;

public class CodecSimple
implements EncoderDecoder {
    private PrefixMapping prefixMapping;

    public CodecSimple() {
        this.prefixMapping = new PrefixMappingImpl();
    }

    public CodecSimple(PrefixMapping pMap) {
        this.prefixMapping = pMap;
    }

    @Override
    public String encode(Node node) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeId().getLabelString();
        }
        String s = FmtUtils.stringForNode((Node)node, (PrefixMapping)this.prefixMapping);
        return s;
    }

    @Override
    public Node decode(String s) {
        if (s.startsWith("Double")) {
            System.err.println(s);
        }
        if (s.startsWith("_:")) {
            return NodeFactory.createAnon((AnonId)new AnonId(s.substring(2)));
        }
        return CodecSimple.stringToNode(s, this.prefixMapping);
    }

    static Node stringToNode(String string, PrefixMapping pmap) {
        return SSE.parseNode((String)string, (PrefixMapping)pmap);
    }
}

