/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.layout1.EncoderDecoder;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.store.SQLBridgeBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.sql.SQLException;
import java.util.List;

public class SQLBridge1
extends SQLBridgeBase {
    private EncoderDecoder codec;

    public SQLBridge1(SDBRequest request, SqlNode sqlNode, List<Var> projectVars, EncoderDecoder codec) {
        super(request, sqlNode, projectVars);
        this.codec = codec;
    }

    @Override
    protected void buildValues() {
        if (this.getSqlNode().isSelectBlock()) {
            this.setSqlNode(this.getSqlNode().asSelectBlock().clearView());
        }
    }

    @Override
    protected void buildProject() {
        for (Var v : this.getProject()) {
            ScopeEntry e;
            if (!v.isNamedVar() || (e = this.getSqlExprNode().getIdScope().findScopeForVar(v)) == null) continue;
            SqlColumn c = e.getColumn();
            String sqlVarName = this.allocSqlName(v);
            this.addProject(c, sqlVarName);
            this.addAnnotation(sqlVarName + "=" + v.toString());
        }
        this.setAnnotation();
    }

    @Override
    protected Binding assembleBinding(ResultSetJDBC rs, Binding parent) {
        BindingMap b = BindingFactory.create((Binding)parent);
        for (Var v : this.getProject()) {
            String sqlVarName = this.getSqlName(v);
            if (sqlVarName == null) continue;
            try {
                String s = rs.get().getString(sqlVarName);
                if (s == null) continue;
                s = SQLUtils.unescapeStr(s);
                Node n = this.codec.decode(s);
                b.add(v, n);
            }
            catch (SQLException ex) {}
        }
        return b;
    }
}

