/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.hash.FmtLayout2HashDerby;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2IndexDerby
extends FmtLayout2HashDerby {
    public FmtLayout2IndexDerby(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        TableDescTriples desc = new TableDescTriples();
        this.dropTable(desc.getTableName());
        try {
            String x = SQLUtils.sqlStr("CREATE TABLE %s (", "    %2$s int NOT NULL,", "    %3$s int NOT NULL,", "    %4$s int NOT NULL,", "    PRIMARY KEY (%2$s, %3$s, %4$s)", ")");
            x = String.format(x, desc.getTableName(), desc.getSubjectColName(), desc.getPredicateColName(), desc.getObjectColName());
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + desc.getTableName() + " (", "    s int NOT NULL,", "    p int NOT NULL,", "    o int NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        TableDescQuads desc = new TableDescQuads();
        this.dropTable(desc.getTableName());
        try {
            String x = SQLUtils.sqlStr("CREATE TABLE %s (", "    %2$s int NOT NULL,", "    %3$s int NOT NULL,", "    %4$s int NOT NULL,", "    %5$s int NOT NULL,", "    PRIMARY KEY (%2$s, %3$s, %4$s, %5$s)", ")");
            x = String.format(x, desc.getTableName(), desc.getGraphColName(), desc.getSubjectColName(), desc.getPredicateColName(), desc.getObjectColName());
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + desc.getTableName() + " (", "    g int NOT NULL,", "    s int NOT NULL,", "    p int NOT NULL,", "    o int NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   id int generated always as identity ,", "   hash BIGINT NOT NULL ,", "   lex CLOB NOT NULL ,", "   lang LONG VARCHAR NOT NULL ,", "   datatype varchar(200) NOT NULL ,", "   type integer NOT NULL ,", "   PRIMARY KEY (id)", ")"));
            this.connection().exec("CREATE UNIQUE INDEX Hash ON " + TableDescNodes.name() + " (hash)");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }
}

