/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.NioFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.openrdf.sail.nativerdf.RecordCache;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

final class SequentialRecordCache
extends RecordCache {
    private static final byte[] MAGIC_NUMBER = new byte[]{115, 114, 99};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final int HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final NioFile nioFile;
    private final int recordSize;

    public SequentialRecordCache(File cacheDir, int recordSize) throws IOException {
        this(cacheDir, recordSize, Long.MAX_VALUE);
    }

    public SequentialRecordCache(File cacheDir, int recordSize, long maxRecords) throws IOException {
        super(maxRecords);
        this.recordSize = recordSize;
        File cacheFile = File.createTempFile("txncache", ".dat", cacheDir);
        this.nioFile = new NioFile(cacheFile);
        this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
        this.nioFile.writeByte((byte)1, (long)MAGIC_NUMBER.length);
    }

    public void discard() throws IOException {
        this.nioFile.delete();
    }

    protected void clearInternal() throws IOException {
        this.nioFile.truncate((long)HEADER_LENGTH);
    }

    protected void storeRecordInternal(byte[] data) throws IOException {
        this.nioFile.writeBytes(data, this.nioFile.size());
    }

    protected RecordIterator getRecordsInternal() {
        return new RecordCacheIterator();
    }

    protected class RecordCacheIterator
    implements RecordIterator {
        private long position = SequentialRecordCache.access$000();

        protected RecordCacheIterator() {
        }

        public byte[] next() throws IOException {
            if (this.position + (long)SequentialRecordCache.this.recordSize <= SequentialRecordCache.this.nioFile.size()) {
                byte[] data = new byte[SequentialRecordCache.this.recordSize];
                ByteBuffer buf = ByteBuffer.wrap(data);
                int bytesRead = SequentialRecordCache.this.nioFile.read(buf, this.position);
                if (bytesRead < 0) {
                    throw new NoSuchElementException("No more elements available");
                }
                this.position += (long)bytesRead;
                return data;
            }
            return null;
        }

        public void set(byte[] value) throws IOException {
            if (this.position >= (long)(HEADER_LENGTH + SequentialRecordCache.this.recordSize) && this.position <= SequentialRecordCache.this.nioFile.size()) {
                SequentialRecordCache.this.nioFile.writeBytes(value, this.position - (long)SequentialRecordCache.this.recordSize);
            }
        }

        public void close() throws IOException {
        }
    }
}

