/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfigBase;
import org.openrdf.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends SailImplConfigBase {
    private String tripleIndexes;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.tripleIndexes != null) {
            graph.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, (Value)vf.createLiteral(this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            graph.add(implNode, NativeStoreSchema.FORCE_SYNC, (Value)vf.createLiteral(this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            graph.add(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, (Value)vf.createLiteral(this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            graph.add(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, (Value)vf.createLiteral(this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            graph.add(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, (Value)vf.createLiteral(this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            graph.add(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, (Value)vf.createLiteral(this.namespaceIDCacheSize), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        block17: {
            super.parse(graph, implNode);
            try {
                Literal namespaceIDCacheSizeLit;
                Literal namespaceCacheSizeLit;
                Literal valueIDCacheSizeLit;
                Literal valueCacheSizeLit;
                Literal forceSyncLit;
                Literal tripleIndexLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.TRIPLE_INDEXES);
                if (tripleIndexLit != null) {
                    this.setTripleIndexes(tripleIndexLit.getLabel());
                }
                if ((forceSyncLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.FORCE_SYNC)) != null) {
                    try {
                        this.setForceSync(forceSyncLit.booleanValue());
                    }
                    catch (IllegalArgumentException e) {
                        throw new SailConfigException("Boolean value required for " + NativeStoreSchema.FORCE_SYNC + " property, found " + forceSyncLit);
                    }
                }
                if ((valueCacheSizeLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.VALUE_CACHE_SIZE)) != null) {
                    try {
                        this.setValueCacheSize(valueCacheSizeLit.intValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SailConfigException("Integer value required for " + NativeStoreSchema.VALUE_CACHE_SIZE + " property, found " + valueCacheSizeLit);
                    }
                }
                if ((valueIDCacheSizeLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.VALUE_ID_CACHE_SIZE)) != null) {
                    try {
                        this.setValueIDCacheSize(valueIDCacheSizeLit.intValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SailConfigException("Integer value required for " + NativeStoreSchema.VALUE_ID_CACHE_SIZE + " property, found " + valueIDCacheSizeLit);
                    }
                }
                if ((namespaceCacheSizeLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.NAMESPACE_CACHE_SIZE)) != null) {
                    try {
                        this.setNamespaceCacheSize(namespaceCacheSizeLit.intValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SailConfigException("Integer value required for " + NativeStoreSchema.NAMESPACE_CACHE_SIZE + " property, found " + namespaceCacheSizeLit);
                    }
                }
                if ((namespaceIDCacheSizeLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE)) == null) break block17;
                try {
                    this.setNamespaceIDCacheSize(namespaceIDCacheSizeLit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE + " property, found " + namespaceIDCacheSizeLit);
                }
            }
            catch (GraphUtilException e) {
                throw new SailConfigException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

