/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryBase;
import org.openrdf.model.util.URIUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.memory.model.BooleanMemLiteral;
import org.openrdf.sail.memory.model.CalendarMemLiteral;
import org.openrdf.sail.memory.model.DecimalMemLiteral;
import org.openrdf.sail.memory.model.IntegerMemLiteral;
import org.openrdf.sail.memory.model.MemBNode;
import org.openrdf.sail.memory.model.MemLiteral;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.NumericMemLiteral;
import org.openrdf.sail.memory.model.WeakObjectRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemValueFactory
extends ValueFactoryBase {
    private final WeakObjectRegistry<MemURI> uriRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemBNode> bnodeRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemLiteral> literalRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<String> namespaceRegistry = new WeakObjectRegistry();

    public void clear() {
        this.uriRegistry.clear();
        this.bnodeRegistry.clear();
        this.literalRegistry.clear();
        this.namespaceRegistry.clear();
    }

    public MemValue getMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getMemLiteral((Literal)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getMemResource(Resource resource) {
        if (resource instanceof URI) {
            return this.getMemURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.getMemBNode((BNode)resource);
        }
        if (resource == null) {
            return null;
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemURI getMemURI(URI uri) {
        if (this.isOwnMemValue((Value)uri)) {
            return (MemURI)uri;
        }
        return this.uriRegistry.get(uri);
    }

    public synchronized MemBNode getMemBNode(BNode bnode) {
        if (this.isOwnMemValue((Value)bnode)) {
            return (MemBNode)bnode;
        }
        return this.bnodeRegistry.get(bnode);
    }

    public synchronized MemLiteral getMemLiteral(Literal literal) {
        if (this.isOwnMemValue((Value)literal)) {
            return (MemLiteral)literal;
        }
        return this.literalRegistry.get(literal);
    }

    private boolean isOwnMemValue(Value value) {
        return value instanceof MemValue && ((MemValue)value).getCreator() == this;
    }

    public Set<MemURI> getMemURIs() {
        return Collections.unmodifiableSet(this.uriRegistry);
    }

    public Set<MemBNode> getMemBNodes() {
        return Collections.unmodifiableSet(this.bnodeRegistry);
    }

    public Set<MemLiteral> getMemLiterals() {
        return Collections.unmodifiableSet(this.literalRegistry);
    }

    public MemValue getOrCreateMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getOrCreateMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getOrCreateMemLiteral((Literal)value);
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getOrCreateMemResource(Resource resource) {
        if (resource instanceof URI) {
            return this.getOrCreateMemURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.getOrCreateMemBNode((BNode)resource);
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemURI getOrCreateMemURI(URI uri) {
        MemURI memURI = this.getMemURI(uri);
        if (memURI == null) {
            String namespace = uri.getNamespace();
            String sharedNamespace = this.namespaceRegistry.get(namespace);
            if (sharedNamespace == null) {
                this.namespaceRegistry.add(namespace);
            } else {
                namespace = sharedNamespace;
            }
            memURI = new MemURI((Object)this, namespace, uri.getLocalName());
            boolean wasNew = this.uriRegistry.add(memURI);
            assert (wasNew) : "Created a duplicate MemURI for URI " + uri;
        }
        return memURI;
    }

    public synchronized MemBNode getOrCreateMemBNode(BNode bnode) {
        MemBNode memBNode = this.getMemBNode(bnode);
        if (memBNode == null) {
            memBNode = new MemBNode((Object)this, bnode.getID());
            boolean wasNew = this.bnodeRegistry.add(memBNode);
            assert (wasNew) : "Created a duplicate MemBNode for bnode " + bnode;
        }
        return memBNode;
    }

    public synchronized MemLiteral getOrCreateMemLiteral(Literal literal) {
        MemLiteral memLiteral = this.getMemLiteral(literal);
        if (memLiteral == null) {
            block12: {
                String label = literal.getLabel();
                URI datatype = literal.getDatatype();
                if (datatype != null) {
                    try {
                        if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                            memLiteral = new IntegerMemLiteral((Object)this, label, literal.integerValue(), datatype);
                            break block12;
                        }
                        if (datatype.equals((Object)XMLSchema.DECIMAL)) {
                            memLiteral = new DecimalMemLiteral((Object)this, label, literal.decimalValue(), datatype);
                            break block12;
                        }
                        if (datatype.equals((Object)XMLSchema.FLOAT)) {
                            memLiteral = new NumericMemLiteral((Object)this, label, Float.valueOf(literal.floatValue()), datatype);
                            break block12;
                        }
                        if (datatype.equals((Object)XMLSchema.DOUBLE)) {
                            memLiteral = new NumericMemLiteral((Object)this, label, literal.doubleValue(), datatype);
                            break block12;
                        }
                        if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                            memLiteral = new BooleanMemLiteral((Object)this, label, literal.booleanValue());
                            break block12;
                        }
                        if (datatype.equals((Object)XMLSchema.DATETIME)) {
                            memLiteral = new CalendarMemLiteral((Object)this, label, datatype, literal.calendarValue());
                            break block12;
                        }
                        memLiteral = new MemLiteral((Object)this, label, datatype);
                    }
                    catch (IllegalArgumentException e) {
                        memLiteral = new MemLiteral((Object)this, label, datatype);
                    }
                } else {
                    memLiteral = literal.getLanguage() != null ? new MemLiteral((Object)this, label, literal.getLanguage()) : new MemLiteral((Object)this, label);
                }
            }
            boolean wasNew = this.literalRegistry.add(memLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + literal;
        }
        return memLiteral;
    }

    public synchronized URI createURI(String uri) {
        URIImpl tempURI = new URIImpl(uri);
        return this.getOrCreateMemURI((URI)tempURI);
    }

    public synchronized URI createURI(String namespace, String localName) {
        MemURI tempURI = null;
        if (URIUtil.isCorrectURISplit((String)namespace, (String)localName)) {
            if (namespace.indexOf(58) == -1) {
                throw new IllegalArgumentException("Not a valid (absolute) URI: " + namespace + localName);
            }
            tempURI = new MemURI(null, namespace, localName);
        } else {
            tempURI = new URIImpl(namespace + localName);
        }
        return this.getOrCreateMemURI(tempURI);
    }

    public synchronized BNode createBNode(String nodeID) {
        BNodeImpl tempBNode = new BNodeImpl(nodeID);
        return this.getOrCreateMemBNode((BNode)tempBNode);
    }

    public synchronized Literal createLiteral(String value) {
        LiteralImpl tempLiteral = new LiteralImpl(value);
        return this.getOrCreateMemLiteral((Literal)tempLiteral);
    }

    public synchronized Literal createLiteral(String value, String language) {
        LiteralImpl tempLiteral = new LiteralImpl(value, language);
        return this.getOrCreateMemLiteral((Literal)tempLiteral);
    }

    public synchronized Literal createLiteral(String value, URI datatype) {
        LiteralImpl tempLiteral = new LiteralImpl(value, datatype);
        return this.getOrCreateMemLiteral((Literal)tempLiteral);
    }

    public synchronized Literal createLiteral(boolean value) {
        BooleanMemLiteral newLiteral = new BooleanMemLiteral((Object)this, value);
        return this.getSharedLiteral(newLiteral);
    }

    protected synchronized Literal createIntegerLiteral(Number n, URI datatype) {
        IntegerMemLiteral newLiteral = new IntegerMemLiteral((Object)this, BigInteger.valueOf(n.longValue()), datatype);
        return this.getSharedLiteral(newLiteral);
    }

    protected synchronized Literal createFPLiteral(Number n, URI datatype) {
        NumericMemLiteral newLiteral = new NumericMemLiteral((Object)this, n, datatype);
        return this.getSharedLiteral(newLiteral);
    }

    public synchronized Literal createLiteral(XMLGregorianCalendar calendar) {
        CalendarMemLiteral newLiteral = new CalendarMemLiteral((Object)this, calendar);
        return this.getSharedLiteral(newLiteral);
    }

    private Literal getSharedLiteral(MemLiteral newLiteral) {
        MemLiteral sharedLiteral = this.literalRegistry.get(newLiteral);
        if (sharedLiteral == null) {
            boolean wasNew = this.literalRegistry.add(newLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + newLiteral;
            sharedLiteral = newLiteral;
        }
        return sharedLiteral;
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        if (context == null) {
            return new StatementImpl(subject, predicate, object);
        }
        return new ContextStatementImpl(subject, predicate, object, context);
    }
}

