/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.engine;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.SDBCompile;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.store.DatasetGraphSDB;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterEquality;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformPropertyFunction;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCheck;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineSDB
extends QueryEngineBase {
    private static Logger log = LoggerFactory.getLogger(QueryEngineSDB.class);
    private Store store;
    private SDBRequest request = null;
    private Op originalOp = null;
    private static QueryEngineFactory factory = new QueryEngineFactorySDB();

    public QueryEngineSDB(Store store, Query q) {
        this(new DatasetGraphSDB(store, SDB.getContext().copy()), q, BindingRoot.create(), SDB.getContext().copy());
    }

    public QueryEngineSDB(DatasetGraphSDB dsg, Query query2, Binding initialBinding, Context context) {
        super(query2, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, query2, initialBinding, context);
    }

    public QueryEngineSDB(DatasetGraphSDB dsg, Op op, Binding initialBinding, Context context) {
        super(op, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, null, initialBinding, context);
    }

    private void init(DatasetGraphSDB dsg, Query query2, Binding initialBinding, Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        if (query2 != null && query2.hasDatasetDescription()) {
            throw new SDBException("Queries with dataset descriptions (FROM/FROM NAMED) not supported");
        }
        if (context.isDefined(ARQConstants.sysDatasetDescription)) {
            throw new SDBException("Queries with dataset descriptions set in the context not supported");
        }
        this.store = dsg.getStore();
        this.request = new SDBRequest(this.store, query2, context);
        Op op = this.originalOp = this.getOp();
        op = Transformer.transform((Transform)new TransformPropertyFunction(context), (Op)op);
        op = Transformer.transform((Transform)new TransformFilterEquality(), (Op)op);
        op = Algebra.toQuadForm((Op)op);
        op = SDBCompile.compile(this.store, op, initialBinding, context, this.request);
        this.setOp(op);
    }

    public SDBRequest getRequest() {
        return this.request;
    }

    public void close() {
        super.close();
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding binding, Context context) {
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory((Context)context));
        if (!(op instanceof OpSQL)) {
            QueryIterSingleton input = QueryIterSingleton.create((Binding)binding, (ExecutionContext)execCxt);
            QueryIterator qIter = QC.execute((Op)op, (QueryIterator)input, (ExecutionContext)execCxt);
            qIter = QueryIteratorCheck.check((QueryIterator)qIter, (ExecutionContext)execCxt);
            return qIter;
        }
        OpSQL opSQL = (OpSQL)op;
        Object qIter = opSQL.getSqlNode() == null ? (binding != null && binding.size() != 0 ? QueryIterSingleton.create((Binding)binding, (ExecutionContext)execCxt) : QueryIterRoot.create((ExecutionContext)execCxt)) : opSQL.exec(binding, execCxt);
        qIter = QueryIteratorCheck.check((QueryIterator)qIter, (ExecutionContext)execCxt);
        return qIter;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    private static class QueryEngineFactorySDB
    implements QueryEngineFactory {
        private QueryEngineFactorySDB() {
        }

        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphSDB;
        }

        public Plan create(Query query2, DatasetGraph dataset, Binding inputBinding, Context context) {
            QueryEngineSDB qe = new QueryEngineSDB((DatasetGraphSDB)dataset, query2, inputBinding, context);
            return qe.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphSDB;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            QueryEngineSDB qe = new QueryEngineSDB((DatasetGraphSDB)dataset, op, inputBinding, context);
            return qe.getPlan();
        }
    }
}

