/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.graph.TransactionHandlerSDB;
import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnectionFactory;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLCommand;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import com.hp.hpl.jena.shared.Command;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDBConnection {
    private static Logger log = LoggerFactory.getLogger(SDBConnection.class);
    private static Generator gen = Gensym.create("connection-");
    private Connection sqlConnection = null;
    TransactionHandler transactionHandler = null;
    String label = gen.next();
    String jdbcURL = "unset";
    public static boolean logSQLExceptions = true;
    public static boolean logSQLStatements = false;
    public static boolean logSQLQueries = false;
    private boolean thisLogSQLExceptions = logSQLExceptions;
    private boolean thisLogSQLStatements = logSQLStatements;
    private boolean thisLogSQLQueries = logSQLQueries;
    static Logger sqlLog = log;

    public SDBConnection(DataSource ds) throws SQLException {
        this(ds.getConnection());
    }

    public SDBConnection(String url, String user, String password) {
        this(SDBConnectionFactory.createSqlConnection(url, user, password));
        this.setLabel(url);
        this.setJdbcURL(url);
    }

    public SDBConnection(Connection jdbcConnection) {
        this(jdbcConnection, null);
    }

    public SDBConnection(Connection jdbcConnection, String url) {
        this.sqlConnection = jdbcConnection;
        this.transactionHandler = new TransactionHandlerSDB(this);
        if (url != null) {
            this.setJdbcURL(url);
        }
    }

    public static SDBConnection none() {
        return new SDBConnection("jdbc:none", null, null);
    }

    public boolean hasSQLConnection() {
        return this.sqlConnection != null;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public ResultSetJDBC execQuery(String sqlString) throws SQLException {
        return this.execQuery(sqlString, -1);
    }

    public ResultSetJDBC execQuery(String sqlString, int fetchSize) throws SQLException {
        if (this.loggingSQLStatements() || this.loggingSQLQueries()) {
            this.writeLog("execQuery", sqlString);
        }
        Connection conn = this.getSqlConnection();
        try {
            Statement s = conn.createStatement(1003, 1007);
            if (fetchSize != -1) {
                s.setFetchSize(fetchSize);
            }
            return new ResultSetJDBC(s, s.executeQuery(sqlString));
        }
        catch (SQLException ex) {
            this.exception("execQuery", ex, sqlString);
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    public Object executeInTransaction(Command c) {
        return this.getTransactionHandler().executeInTransaction(c);
    }

    public Object executeSQL(SQLCommand c) {
        try {
            return c.execute(this.getSqlConnection());
        }
        catch (SQLException ex) {
            this.exception("SQL", ex);
            throw new SDBExceptionSQL(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execUpdate(String sqlString) throws SQLException {
        if (this.loggingSQLStatements()) {
            this.writeLog("execUpdate", sqlString);
        }
        Connection conn = this.getSqlConnection();
        try (Statement s = conn.createStatement();){
            int n = s.executeUpdate(sqlString);
            return n;
        }
        catch (SQLException ex) {
            this.exception("execUpdate", ex, sqlString);
            throw ex;
        }
    }

    public ResultSetJDBC exec(String sqlString) throws SQLException {
        if (this.loggingSQLStatements()) {
            this.writeLog("exec", sqlString);
        }
        Connection conn = this.getSqlConnection();
        Statement s = null;
        try {
            s = conn.createStatement();
            boolean r = s.execute(sqlString);
            if (r) {
                return new ResultSetJDBC(s, s.getResultSet());
            }
            RS.close(s);
            return null;
        }
        catch (SQLException ex) {
            RS.close(s);
            this.exception("exec", ex, sqlString);
            throw ex;
        }
    }

    public ResultSetJDBC execSilent(String sqlString) {
        if (this.loggingSQLStatements()) {
            this.writeLog("execSilent", sqlString);
        }
        Connection conn = this.getSqlConnection();
        Statement s = null;
        try {
            s = conn.createStatement();
            boolean r = s.execute(sqlString);
            if (r) {
                return new ResultSetJDBC(s, s.getResultSet());
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        RS.close(s);
        return null;
    }

    public PreparedStatement prepareStatement(String sqlString) throws SQLException {
        if (this.loggingSQLStatements()) {
            this.writeLog("prepareStatement", sqlString);
        }
        Connection conn = this.getSqlConnection();
        try {
            PreparedStatement ps = conn.prepareStatement(sqlString);
            return ps;
        }
        catch (SQLException ex) {
            this.exception("prepareStatement", ex, sqlString);
            throw ex;
        }
    }

    public void closePreparedStatement(PreparedStatement ps) throws SQLException {
        if (this.loggingSQLStatements()) {
            this.writeLog("closePrepareStatement", ps.toString());
        }
        if (ps == null) {
            return;
        }
        try {
            ps.close();
        }
        catch (SQLException ex) {
            this.exception("closePrepareStatement", ex, ps.toString());
            throw ex;
        }
    }

    public List<String> getTableNames() {
        return TableUtils.getTableNames(this.getSqlConnection());
    }

    public Connection getSqlConnection() {
        return this.sqlConnection;
    }

    public void close() {
        Connection connection = this.getSqlConnection();
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            log.warn("Problems closing SQL connection", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean loggingSQLExceptions() {
        return this.thisLogSQLExceptions;
    }

    public void setLogSQLExceptions(boolean thisLogSQLExceptions) {
        this.thisLogSQLExceptions = thisLogSQLExceptions;
    }

    public boolean loggingSQLQueries() {
        return this.thisLogSQLQueries;
    }

    public void setLogSQLQueries(boolean thisLogSQLQueries) {
        this.thisLogSQLQueries = thisLogSQLQueries;
    }

    public boolean loggingSQLStatements() {
        return this.thisLogSQLStatements;
    }

    public void setLogSQLStatements(boolean thisLogSQLStatements) {
        this.thisLogSQLStatements = thisLogSQLStatements;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    private void exception(String who, SQLException ex, String sqlString) {
        if (this.loggingSQLExceptions()) {
            sqlLog.warn(who + ": SQLException\n" + ex.getMessage() + "\n" + sqlString + "\n");
        }
    }

    private void exception(String who, SQLException ex) {
        if (this.loggingSQLExceptions()) {
            sqlLog.warn(who + ": SQLException\n" + ex.getMessage());
        }
    }

    private void writeLog(String who, String sqlString) {
        if (sqlLog.isInfoEnabled()) {
            sqlLog.info(who + "\n\n" + sqlString + "\n");
        }
    }
}

