/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.common.Constants;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationConfigurator;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateArchetypeFromProjectMojo
extends AbstractMojo {
    private ArchetypeCreationConfigurator configurator;
    private boolean interactive;
    private ArchetypeManager manager;
    private String archetypeFilteredExtentions;
    private String archetypeLanguages;
    private File archetypeRegistryFile;
    private String defaultEncoding;
    private boolean partialArchetype = false;
    private boolean preserveCData = false;
    private ArtifactRepository localRepository;
    private boolean keepParent = true;
    private MavenProject project;
    private File propertyFile;
    private String archetypePostPhase;
    private File outputDirectory;
    private boolean testMode;
    private String packageName;
    private MavenSession session;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties executionProperties = this.session.getExecutionProperties();
        try {
            if (this.propertyFile != null) {
                this.propertyFile.getParentFile().mkdirs();
            }
            List<String> languages = this.getLanguages(this.archetypeLanguages, this.propertyFile);
            Properties properties = this.configurator.configureArchetypeCreation(this.project, this.interactive, executionProperties, this.propertyFile, languages);
            List<String> filtereds = this.getFilteredExtensions(this.archetypeFilteredExtentions, this.propertyFile);
            ArchetypeCreationRequest request = new ArchetypeCreationRequest().setDefaultEncoding(this.defaultEncoding).setProject(this.project).setProperties(properties).setLanguages(languages).setFiltereds(filtereds).setPreserveCData(this.preserveCData).setKeepParent(this.keepParent).setPartialArchetype(this.partialArchetype).setArchetypeRegistryFile(this.archetypeRegistryFile).setLocalRepository(this.localRepository).setPackageName(this.packageName).setPostPhase(this.archetypePostPhase).setOutputDirectory(this.outputDirectory);
            ArchetypeCreationResult result = this.manager.createArchetypeFromProject(request);
            if (result.getCause() != null) {
                throw new MojoFailureException((Object)result.getCause(), result.getCause().getMessage(), result.getCause().getMessage());
            }
            this.getLog().info((CharSequence)("Archetype created in " + this.outputDirectory));
            if (!this.testMode) return;
        }
        catch (MojoFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoFailureException((Object)ex, ex.getMessage(), ex.getMessage());
        }
    }

    private List<String> getFilteredExtensions(String archetypeFilteredExtentions, File propertyFile) {
        ArrayList<String> filteredExtensions = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)archetypeFilteredExtentions)) {
            filteredExtensions.addAll(Arrays.asList(StringUtils.split((String)archetypeFilteredExtentions, (String)",")));
            this.getLog().debug((CharSequence)("Found in command line extensions = " + filteredExtensions));
        }
        if (filteredExtensions.isEmpty() && propertyFile != null && propertyFile.exists()) {
            Properties properties = PropertyUtils.loadProperties((File)propertyFile);
            String extensions = properties.getProperty("archetype.filteredExtensions");
            if (StringUtils.isNotEmpty((String)extensions)) {
                filteredExtensions.addAll(Arrays.asList(StringUtils.split((String)extensions, (String)",")));
            }
            this.getLog().debug((CharSequence)("Found in propertyFile " + propertyFile.getName() + " extensions = " + filteredExtensions));
        }
        if (filteredExtensions.isEmpty()) {
            filteredExtensions.addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
            this.getLog().debug((CharSequence)("Using default extensions = " + filteredExtensions));
        }
        return filteredExtensions;
    }

    private List<String> getLanguages(String archetypeLanguages, File propertyFile) {
        ArrayList<String> resultingLanguages = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)archetypeLanguages)) {
            resultingLanguages.addAll(Arrays.asList(StringUtils.split((String)archetypeLanguages, (String)",")));
            this.getLog().debug((CharSequence)("Found in command line languages = " + resultingLanguages));
        }
        if (resultingLanguages.isEmpty() && propertyFile != null && propertyFile.exists()) {
            Properties properties = PropertyUtils.loadProperties((File)propertyFile);
            String languages = properties.getProperty("archetype.languages");
            if (StringUtils.isNotEmpty((String)languages)) {
                resultingLanguages.addAll(Arrays.asList(StringUtils.split((String)languages, (String)",")));
            }
            this.getLog().debug((CharSequence)("Found in propertyFile " + propertyFile.getName() + " languages = " + resultingLanguages));
        }
        if (resultingLanguages.isEmpty()) {
            resultingLanguages.addAll(Constants.DEFAULT_LANGUAGES);
            this.getLog().debug((CharSequence)("Using default languages = " + resultingLanguages));
        }
        return resultingLanguages;
    }
}

