/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-archetype-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Archetype Plugin", 0);
        this.append(sb, "Maven Archetype is a set of tools to deal with archetypes, i.e. an abstract representation of a kind of project that can be instantiated into a concrete customized Maven project. An archetype knows which files will be part of the instantiated project and which properties to fill to properly customize the project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "crawl".equals(this.goal)) {
            this.append(sb, "archetype:crawl", 0);
            this.append(sb, "Crawl a Maven repository (filesystem, not HTTP) and creates a catalog file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "catalogFile", 2);
                this.append(sb, "The archetype's catalog to update.", 3);
                this.append(sb, "Expression: ${catalog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "repository (Default: ${settings.localRepository})", 2);
                this.append(sb, "The repository to crawl.", 3);
                this.append(sb, "Expression: ${repository}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "create".equals(this.goal)) {
            this.append(sb, "archetype:create", 0);
            this.append(sb, "Deprecated. Please use the generate mojo instead.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "The archetype creation goal looks for an archetype with a given groupId, artifactId, and version and retrieves it from the remote repository. Once the archetype is retrieved, it is then processed against a set of user parameters to create a working Maven project.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archetypeArtifactId (Default: maven-archetype-quickstart)", 2);
                this.append(sb, "The Archetype Artifact Id to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${archetypeArtifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeGroupId (Default: org.apache.maven.archetypes)", 2);
                this.append(sb, "The Archetype Group Id to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${archetypeGroupId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeVersion (Default: RELEASE)", 2);
                this.append(sb, "The Archetype Version to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${archetypeVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "The Artifact Id of the project to be build.", 3);
                this.append(sb, "Expression: ${artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${user.dir})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "The Group Id of the project to be build.", 3);
                this.append(sb, "Expression: ${groupId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "Maven's local repository.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName", 2);
                this.append(sb, "The Package Name of the project to be build.", 3);
                this.append(sb, "Expression: ${packageName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomRemoteRepositories", 2);
                this.append(sb, "The remote repositories available for discovering dependencies and extensions as indicated by the POM.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The project to be created an archetype of.", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "Other remote repositories available for discovering dependencies and extensions.", 3);
                this.append(sb, "Expression: ${remoteRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: 1.0-SNAPSHOT)", 2);
                this.append(sb, "The Version of the project to be build.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${version}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "create-from-project".equals(this.goal)) {
            this.append(sb, "archetype:create-from-project", 0);
            this.append(sb, "Creates an archetype project from the current project.\n\nThis goal reads your source and resource files, the values of its parameters, and properties you specify in a .property file, and uses them to create a Maven archetype project using the maven-archetype packaging. If you build the resulting project, it will create the archetype. You can then use this archetype to create new projects that resemble the original.\n\nThe maven-archetype-plugin uses Velocity to expand template files, and this documentation talks about 'Velocity Properties', which are values substituted into Velocity templates. See The Velocity User's Guide for more information.\n\nThis goal modifies the text of the files of the current project to form the Velocity template files that make up the archetype.\n\nGAV\n\tThe GAV values for the current project are replaced by properties: groupId, artifactId, and version. The user chooses new values for these when generating a project from the archetype.\npackage\n\tAll the files under one specified Java (or cognate) package are relocated to a project that the user chooses when generating a project. References to the class name are replaced by a property reference. For example, if the current project's sources are in the package org.apache.saltedpeanuts, then any example of the string org.apache.saltedpeanuts is replaced with the Velocity property reference ${packageName}. When the user generates a project, this is in turn replaced by his or her choice of a package.\ncustom properties\n\tYou may identify additional strings that should be replaced by parameters. To add custom properties, you must use the propertyFile parameter to specify a property file. See the documentation for propertyFile for the details.\n\nNote that you may need to edit the results of this goal. This goal has no way to exclude unwanted files, or add copyright notices to the Velocity templates, or add more complex elements to the archetype metadata file.\n\nThis goal also generates a simple integration-test that exercises the generated archetype.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archetypeFilteredExtentions", 2);
                this.append(sb, "File extensions which are checked for project's text files (vs binary files).", 3);
                this.append(sb, "Expression: ${archetype.filteredExtentions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeLanguages", 2);
                this.append(sb, "Directory names which are checked for project's sources main package.", 3);
                this.append(sb, "Expression: ${archetype.languages}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypePostPhase (Default: package)", 2);
                this.append(sb, "The property telling which phase to call on the generated archetype. Interesting values are: package, integration-test, install and deploy.", 3);
                this.append(sb, "Expression: ${archetype.postPhase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeRegistryFile", 2);
                this.append(sb, "The location of the registry file.", 3);
                this.append(sb, "Expression: ${user.home}/.m2/archetype.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultEncoding (Default: UTF-8)", 2);
                this.append(sb, "Velocity templates encoding.", 3);
                this.append(sb, "Expression: ${archetype.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactive (Default: false)", 2);
                this.append(sb, "Enable the interactive mode to define the archetype from the project.", 3);
                this.append(sb, "Expression: ${interactive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepParent", 2);
                this.append(sb, "POMs in archetype are created with their initial parent. This property is ignored when preserveCData is true.", 3);
                this.append(sb, "Expression: ${archetype.keepParent}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory where the archetype should be created.", 3);
                this.append(sb, "Expression: ${project.build.directory}/generated-sources/archetype", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName", 2);
                this.append(sb, "The package name for Java source files to be incorporated in the archetype and and relocated to the package that the user selects.", 3);
                this.append(sb, "Expression: ${packageName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "partialArchetype", 2);
                this.append(sb, "Create a partial archetype.", 3);
                this.append(sb, "Expression: ${archetype.partialArchetype}", 3);
                this.append(sb, "", 0);
                this.append(sb, "preserveCData", 2);
                this.append(sb, "Create pom's velocity templates with CDATA preservation. This uses the String.replaceAll() method and risks to have some overly replacement capabilities (beware of '1.0' value).", 3);
                this.append(sb, "Expression: ${archetype.preserveCData}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFile", 2);
                this.append(sb, "The property file that holds the plugin configuration. If this is provided, then the plugin reads properties from here. The properties in here can be standard properties listed below or custom properties for this archetype. The standard properties are below. Several of them overlap parameters of this goal; it's better to just set the parameter.\npackage\n\tSee the packageName parameter.\narchetype.languages\n\tSee the archetypeLanguages parameter.\ngroupId\n\tThe default groupId of the generated project.\nartifactId\n\tThe default artifactId of the generated project.\nversion\n\tThe default version of the generated project.\narchetype.filteredExtensions\n\tSee the filteredExensions parameter.\nCustom Properties\nCustom properties allow you to replace some constant values in the project's files with Velocity macro references. When a user generates a project from your archetype he or she gets the opportunity to replace the value from the source project.\n\nCustom property names may not contain the '.' character.\n\nFor example, if you include a line like the following in your property file:\n\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0cxf-version=2.5.1-SNAPSHOT\nthe plugin will search your files for the string\n2.5.1-SNAPSHOT\nand replace them with references to a velocity macro\ncxf-version\n. It will then list\ncxf-version\nas a\nrequiredProperty\nin the archetype-metadata.xml, with\n2.5.1-SNAPSHOT\nas the default value.\n\n", 3);
                this.append(sb, "Expression: ${archetype.properties}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testMode", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${testMode}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "archetype:generate", 0);
            this.append(sb, "Generates a new project from an archetype, or updated the actual project if using a partial archetype. If the project is fully generated, it is generated in a directory corresponding to its artifactId. If the project is updated with a partial archetype, it is done in the current directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archetypeArtifactId", 2);
                this.append(sb, "The archetype's artifactId.", 3);
                this.append(sb, "Expression: ${archetypeArtifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeCatalog (Default: remote,local)", 2);
                this.append(sb, "The archetype catalogs to use to build a list and let the user choose from. It is a comma separated list of catalogs. Catalogs use following schemes:\n-\t'file://...' with archetype-catalog.xml automatically appended when pointing to a directory\n-\t'http://...' or 'https://...' with archetype-catalog.xml always appended\n-\t'local' which is the shortcut for 'file://~/.m2/archetype-catalog.xml'\n-\t'remote' which is the shortcut for Maven Central repository, ie 'http://repo1.maven.org/maven2'\n-\t'internal' which is an internal catalog\nSince 2.0-alpha-5, default value is no longer internal,local but remote,local. If Maven Central repository catalog file is empty, internal catalog is used instead.", 3);
                this.append(sb, "Expression: ${archetypeCatalog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeGroupId", 2);
                this.append(sb, "The archetype's groupId.", 3);
                this.append(sb, "Expression: ${archetypeGroupId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeRepository", 2);
                this.append(sb, "The archetype's repository.", 3);
                this.append(sb, "Expression: ${archetypeRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "archetypeVersion", 2);
                this.append(sb, "The archetype's version.", 3);
                this.append(sb, "Expression: ${archetypeVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filter", 2);
                this.append(sb, "Applying some filter on displayed archetypes list: format is artifactId or groupId:artifactId.\n-\torg.apache: -> displays all archetypes which contain org.apache in groupId\n-\t:jee or jee -> displays all archetypes which contain jee in artifactId\n-\torg.apache:jee -> displays all archetypes which contain org.apache in groupId AND jee in artifactId\n", 3);
                this.append(sb, "Expression: ${filter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "Additional goals to immediately run on the project created from the archetype.", 3);
                this.append(sb, "Expression: ${goals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "User settings use to check the interactiveMode.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${interactiveMode}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "archetype:help", 0);
            this.append(sb, "Display help information on maven-archetype-plugin.\nCall\n\u00a0\u00a0mvn\u00a0archetype:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "integration-test".equals(this.goal)) {
            this.append(sb, "archetype:integration-test", 0);
            this.append(sb, "Execute the archetype integration tests, consisting in generating projects from the current archetype and optionally comparing generated projects with reference copy.\n\nEach IT consists of a sub-directory in src/test/resources/projects containing:\n\n-\ta goal.txt file, containing a list of goals to run against the generated project (can be empty, content ignored before maven-archetype-plugin 2.1),\n-\tan archetype.properties file, containing properties for project generation,\n-\tan optional reference/ directory containing a reference copy of the expected project created from the IT.\nNotice that it is expected to be run as part as of a build after the package phase and not directly as a goal from CLI.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Whether to show debug statements in the build output.", 3);
                this.append(sb, "Expression: ${archetype.test.debug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding for the post-build script.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterProperties", 2);
                this.append(sb, "A list of additional properties which will be used to filter tokens in settings.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "noLog (Default: false)", 2);
                this.append(sb, "Suppress logging to the build.log file.", 3);
                this.append(sb, "Expression: ${archetype.test.noLog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "postBuildHookScript (Default: verify)", 2);
                this.append(sb, "Relative path of a cleanup/verification hook script to run after executing the build. This script may be written with either BeanShell or Groovy. If the file extension is omitted (e.g. verify), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true or throws an exception, the corresponding build is flagged as a failure.", 3);
                this.append(sb, "Expression: ${archetype.test.verifyScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsFile", 2);
                this.append(sb, "Path to an alternate settings.xml to use for Maven invocation with all ITs. Note that the <localRepository> element of this settings file is always ignored, i.e. the path given by the parameter localRepositoryPath is dominant.", 3);
                this.append(sb, "Expression: ${archetype.test.settingsFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "showVersion (Default: false)", 2);
                this.append(sb, "flag to enable show mvn version used for running its (cli option : -V,--show-version )", 3);
                this.append(sb, "Expression: ${archetype.test.showVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "streamLogs (Default: true)", 2);
                this.append(sb, "Flag used to determine whether the build logs should be output to the normal mojo log.", 3);
                this.append(sb, "Expression: ${archetype.test.streamLogs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testProjectsDirectory (Default: ${project.build.testOutputDirectory}/projects)", 2);
                this.append(sb, "Directory of test projects", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${archetype.test.projectsDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar".equals(this.goal)) {
            this.append(sb, "archetype:jar", 0);
            this.append(sb, "Build a JAR from the current Archetype project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archetypeDirectory", 2);
                this.append(sb, "Directory containing the classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Name of the generated JAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory containing the generated JAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-local-catalog".equals(this.goal)) {
            this.append(sb, "archetype:update-local-catalog", 0);
            this.append(sb, "Updates the local catalog", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

