/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui;

import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.codehaus.plexus.util.StringUtils;

public class ArchetypeDefinition {
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private String repository;
    private String goals;
    private String url;
    private String description;

    public ArchetypeDefinition() {
    }

    public ArchetypeDefinition(ArchetypeGenerationRequest request) {
        this.setGroupId(request.getArchetypeGroupId());
        this.setArtifactId(request.getArchetypeArtifactId());
        this.setVersion(request.getArchetypeVersion());
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGoals() {
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void reset() {
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion(null);
    }

    public boolean isArtifactDefined() {
        return StringUtils.isNotEmpty((String)this.getArtifactId());
    }

    public boolean isDefined() {
        return this.isPartiallyDefined() && this.isVersionDefined();
    }

    public boolean isGroupDefined() {
        return StringUtils.isNotEmpty((String)this.getGroupId());
    }

    public boolean isPartiallyDefined() {
        return this.isGroupDefined() && this.isArtifactDefined();
    }

    public boolean isVersionDefined() {
        return StringUtils.isNotEmpty((String)this.getVersion());
    }

    public void updateRequest(ArchetypeGenerationRequest request) {
        request.setArchetypeGroupId(this.getGroupId());
        request.setArchetypeArtifactId(this.getArtifactId());
        request.setArchetypeVersion(this.getVersion());
        request.setArchetypeGoals(this.getGoals());
        request.setArchetypeName(this.getName());
        if (StringUtils.isNotEmpty((String)this.getRepository())) {
            request.setArchetypeRepository(this.getRepository());
        }
    }
}

