/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.ArchetypeRegistryManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationConfigurationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationQueryer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ArchetypeGenerationConfigurator.class)
public class DefaultArchetypeGenerationConfigurator
extends AbstractLogEnabled
implements ArchetypeGenerationConfigurator {
    @Requirement
    OldArchetype oldArchetype;
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;
    @Requirement
    private ArchetypeFactory archetypeFactory;
    @Requirement
    private ArchetypeGenerationQueryer archetypeGenerationQueryer;
    @Requirement
    private ArchetypeRegistryManager archetypeRegistryManager;

    public void setArchetypeArtifactManager(ArchetypeArtifactManager archetypeArtifactManager) {
        this.archetypeArtifactManager = archetypeArtifactManager;
    }

    public void configureArchetype(ArchetypeGenerationRequest request, Boolean interactiveMode, Properties executionProperties) throws ArchetypeNotDefined, UnknownArchetype, ArchetypeNotConfigured, IOException, PrompterException, ArchetypeGenerationConfigurationFailure {
        ArchetypeConfiguration archetypeConfiguration;
        org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor;
        ArtifactRepository localRepository = request.getLocalRepository();
        ArtifactRepository archetypeRepository = null;
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        Properties properties = new Properties(executionProperties);
        ArchetypeDefinition ad = new ArchetypeDefinition(request);
        if (!ad.isDefined()) {
            if (!interactiveMode.booleanValue()) {
                throw new ArchetypeNotDefined("No archetype was chosen");
            }
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        if (request.getArchetypeRepository() != null) {
            archetypeRepository = this.archetypeRegistryManager.createRepository(request.getArchetypeRepository(), ad.getArtifactId() + "-repo");
            repositories.add(archetypeRepository);
        }
        if (request.getRemoteArtifactRepositories() != null) {
            repositories.addAll(request.getRemoteArtifactRepositories());
        }
        if (!this.archetypeArtifactManager.exists(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories)) {
            throw new UnknownArchetype("The desired archetype does not exist (" + ad.getGroupId() + ":" + ad.getArtifactId() + ":" + ad.getVersion() + ")");
        }
        request.setArchetypeVersion(ad.getVersion());
        if (this.archetypeArtifactManager.isFileSetArchetype(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories)) {
            archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories);
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration(archetypeDescriptor, properties);
        } else if (this.archetypeArtifactManager.isOldArchetype(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories)) {
            archetypeDescriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories);
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration((ArchetypeDescriptor)archetypeDescriptor, properties);
        } else {
            throw new ArchetypeGenerationConfigurationFailure("The defined artifact is not an archetype");
        }
        if (interactiveMode.booleanValue()) {
            boolean confirmed = false;
            while (!confirmed) {
                List<String> propertiesRequired = archetypeConfiguration.getRequiredProperties();
                this.getLogger().debug("Required properties before content sort: " + propertiesRequired);
                Collections.sort(propertiesRequired, new RequiredPropertyComparator(archetypeConfiguration));
                this.getLogger().debug("Required properties after content sort: " + propertiesRequired);
                if (!archetypeConfiguration.isConfigured()) {
                    for (String requiredProperty : propertiesRequired) {
                        if (!archetypeConfiguration.isConfigured(requiredProperty)) {
                            if ("package".equals(requiredProperty)) {
                                String packageDefault = archetypeConfiguration.getDefaultValue(requiredProperty);
                                packageDefault = null == packageDefault || "".equals(packageDefault) ? archetypeConfiguration.getProperty("groupId") : archetypeConfiguration.getDefaultValue(requiredProperty);
                                String value = this.getTransitiveDefaultValue(packageDefault, archetypeConfiguration);
                                value = this.archetypeGenerationQueryer.getPropertyValue(requiredProperty, value);
                                archetypeConfiguration.setProperty(requiredProperty, value);
                                continue;
                            }
                            String value = archetypeConfiguration.getDefaultValue(requiredProperty);
                            value = this.getTransitiveDefaultValue(value, archetypeConfiguration);
                            value = this.archetypeGenerationQueryer.getPropertyValue(requiredProperty, value);
                            archetypeConfiguration.setProperty(requiredProperty, value);
                            continue;
                        }
                        this.getLogger().info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                    }
                } else {
                    for (String requiredProperty : propertiesRequired) {
                        this.getLogger().info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                    }
                }
                if (!archetypeConfiguration.isConfigured()) {
                    this.getLogger().warn("Archetype is not fully configured");
                    continue;
                }
                if (!this.archetypeGenerationQueryer.confirmConfiguration(archetypeConfiguration)) {
                    this.getLogger().debug("Archetype generation configuration not confirmed");
                    archetypeConfiguration.reset();
                    this.restoreCommandLineProperties(archetypeConfiguration, executionProperties);
                    continue;
                }
                this.getLogger().debug("Archetype generation configuration confirmed");
                confirmed = true;
            }
        } else if (!archetypeConfiguration.isConfigured()) {
            for (String requiredProperty : archetypeConfiguration.getRequiredProperties()) {
                if (archetypeConfiguration.isConfigured(requiredProperty) || archetypeConfiguration.getDefaultValue(requiredProperty) == null) continue;
                archetypeConfiguration.setProperty(requiredProperty, archetypeConfiguration.getDefaultValue(requiredProperty));
            }
            if (!archetypeConfiguration.isConfigured()) {
                StringBuffer exceptionMessage = new StringBuffer();
                exceptionMessage.append("Archetype ");
                exceptionMessage.append(request.getArchetypeGroupId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeArtifactId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeVersion());
                exceptionMessage.append(" is not configured");
                ArrayList<String> missingProperties = new ArrayList<String>(0);
                for (String requiredProperty : archetypeConfiguration.getRequiredProperties()) {
                    if (archetypeConfiguration.isConfigured(requiredProperty)) continue;
                    exceptionMessage.append("\n\tProperty ");
                    exceptionMessage.append(requiredProperty);
                    missingProperties.add(requiredProperty);
                    exceptionMessage.append(" is missing.");
                    this.getLogger().warn("Property " + requiredProperty + " is missing. Add -D" + requiredProperty + "=someValue");
                }
                throw new ArchetypeNotConfigured(exceptionMessage.toString(), missingProperties);
            }
        }
        request.setGroupId(archetypeConfiguration.getProperty("groupId"));
        request.setArtifactId(archetypeConfiguration.getProperty("artifactId"));
        request.setVersion(archetypeConfiguration.getProperty("version"));
        request.setPackage(archetypeConfiguration.getProperty("package"));
        properties = archetypeConfiguration.getProperties();
        request.setProperties(properties);
    }

    private String getTransitiveDefaultValue(String defaultValue, ArchetypeConfiguration archetypeConfiguration) {
        String result = defaultValue;
        if (null == result) {
            return null;
        }
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            if (result.indexOf("${" + property + "}") < 0) continue;
            result = StringUtils.replace((String)result, (String)("${" + property + "}"), (String)archetypeConfiguration.getProperty(property));
        }
        return result;
    }

    private void restoreCommandLineProperties(ArchetypeConfiguration archetypeConfiguration, Properties executionProperties) {
        this.getLogger().debug("Restoring command line properties");
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            if (!executionProperties.containsKey(property)) continue;
            archetypeConfiguration.setProperty(property, executionProperties.getProperty(property));
            this.getLogger().debug("Restored " + property + "=" + archetypeConfiguration.getProperty(property));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequiredPropertyComparator
    implements Comparator<String> {
        private final ArchetypeConfiguration archetypeConfiguration;

        public RequiredPropertyComparator(ArchetypeConfiguration archetypeConfiguration) {
            this.archetypeConfiguration = archetypeConfiguration;
        }

        @Override
        public int compare(String left, String right) {
            String leftDefault = this.archetypeConfiguration.getDefaultValue(left);
            if (leftDefault != null && leftDefault.indexOf("${" + right + "}") >= 0) {
                return 1;
            }
            String rightDefault = this.archetypeConfiguration.getDefaultValue(right);
            if (rightDefault != null && rightDefault.indexOf("${" + left + "}") >= 0) {
                return -1;
            }
            return this.comparePropertyName(left, right);
        }

        private int comparePropertyName(String left, String right) {
            if ("groupId".equals(left)) {
                return -1;
            }
            if ("groupId".equals(right)) {
                return 1;
            }
            if ("artifactId".equals(left)) {
                return -1;
            }
            if ("artifactId".equals(right)) {
                return 1;
            }
            if ("version".equals(left)) {
                return -1;
            }
            if ("version".equals(right)) {
                return 1;
            }
            if ("package".equals(left)) {
                return -1;
            }
            if ("package".equals(right)) {
                return 1;
            }
            return left.compareTo(right);
        }
    }
}

