/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.assembler.CommandAssemblerException;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;

public class QueryAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource cmd, Mode mode) {
        if (cmd.hasProperty(AssemblerVocab.pQueryFile) && cmd.hasProperty(AssemblerVocab.pQueryString)) {
            throw new CommandAssemblerException(cmd, "Both " + FmtUtils.stringForResource((Resource)AssemblerVocab.pQueryString) + " and " + FmtUtils.stringForResource((Resource)AssemblerVocab.pQueryFile) + " present");
        }
        if (!cmd.hasProperty(AssemblerVocab.pQueryFile) && !cmd.hasProperty(AssemblerVocab.pQueryString)) {
            throw new CommandAssemblerException(cmd, "No queryString or queryFile present");
        }
        String queryString = GraphUtils.getStringValue((Resource)cmd, (Property)AssemblerVocab.pQueryString);
        if (queryString == null) {
            String filename = GraphUtils.getStringValue((Resource)cmd, (Property)AssemblerVocab.pQueryFile);
            queryString = FileManager.get().readWholeFileAsUTF8(filename);
        }
        return QueryFactory.create((String)queryString);
    }
}

